<?php
session_start();
include("../include/dbconnect.php");
include("../include/functions.php");


$qty_decimals = find_value('v_system','qty_decimals','');
$rate_decimals = find_value('v_system','rate_decimals','');
$amt_decimals = find_value('v_system','amt_decimals','');


/*****************************START TO ACCOUNT LEDGER*************************/
if($_POST['action'] == "to_party_bal") {
    $to_acct_id = clean_data($_POST['to_acct_id']);
    //$brand_id = clean_data($_POST['brand_id']);


    $comp_id = $_SESSION["comp_id"];

    try {
        $item_query = "SELECT   
    o.type_id cat_id, 
    upper(o.type_name) cat_name,   
    upper(o.party_name) description,
    o.o_qty,
    o.o_amt,
    voucher_id
FROM
    (
    SELECT
        v.type_id,
        v.type_name,
        v.party_id,
        v.party_name,
        
        sum(ifnull(v.db_qty, 0) - ifnull(v.cr_qty, 0)) o_qty,
        sum(ifnull(v.db_amt, 0) - ifnull(v.cr_amt, 0)) o_amt,
        concat(v.comp_id,v.year_id,v.voucher_id) voucher_id
    FROM
        v_loading_stk v
    WHERE
        v.party_id = '$to_acct_id'
    GROUP BY
        v.type_id,
        v.party_id,
        v.party_name
) o
    WHERE (o.o_qty<>0)
    order by o.type_name, o.party_name";
        $item_result = $dbcon->prepare($item_query);
        $item_result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }



// Create empty array to hold query results
    $someArray = [];
// Loop through query and push results into $someArray;

    while ($item_row = $item_result->fetch(PDO::FETCH_ASSOC)) {


        $o_rate = '';
        if ($item_row['o_qty'] <> 0)
            $o_rate = $item_row['o_amt'] / $item_row['o_qty'];

        array_push($someArray, [

            'description' => $item_row['description'],
            'cat_id' => $item_row['cat_id'],
            'cat_name' => $item_row['cat_name'],
            'o_qty' => round($item_row['o_qty'],$qty_decimals),
            'o_rate' => round($o_rate, $qty_decimals),
            'o_amt' => round($item_row['o_amt'], $qty_decimals),
            'voucher_id' => ($item_row['voucher_id'])

        ]);
    }

// Convert the Array to a JSON String and echo it
    $someJSON = json_encode($someArray);
    echo $someJSON;
}
/*****************************END TO ACCOUNT LEDGER*************************/







/*****************************START FROM ACCOUNT LEDGER*************************/
if($_POST['action'] == "from_party_bal") {
    $acct_id = clean_data($_POST['acct_id']);


    $comp_id = $_SESSION["comp_id"];

    try {
        $item_query = "SELECT   
    o.type_id cat_id, 
    upper(o.type_name) cat_name,   
    upper(o.party_name) description,
    o.o_qty,
    o.o_amt,
    voucher_id
FROM
    (
    SELECT
        v.type_id,
        v.type_name,
        v.party_id,
        v.party_name,
        sum(ifnull(v.db_qty, 0) - ifnull(v.cr_qty, 0)) o_qty,
        sum(ifnull(v.db_amt, 0) - ifnull(v.cr_amt, 0)) o_amt,
        concat(v.comp_id,v.year_id,v.voucher_id) voucher_id
    FROM
        v_loading_stk v
    WHERE
        v.party_id = '$acct_id'
    GROUP BY
        v.type_id,
        v.party_id,
        v.party_name
) o
    WHERE (o.o_qty<>0)
    order by o.type_name, o.party_name";
        $item_result = $dbcon->prepare($item_query);
        $item_result->execute(array());
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }




// Create empty array to hold query results
    $someArray = [];
// Loop through query and push results into $someArray;

    while ($item_row = $item_result->fetch(PDO::FETCH_ASSOC)) {


        $o_rate = '';
        if ($item_row['o_qty'] <> 0)
            $o_rate = $item_row['o_amt'] / $item_row['o_qty'];

        array_push($someArray, [

            'description' => $item_row['description'],
            'cat_id' => $item_row['cat_id'],
            'cat_name' => $item_row['cat_name'],
            'o_qty' => $item_row['o_qty'],
            'o_rate' => round($o_rate, 3),
            'o_amt' => $item_row['o_amt'],
            'voucher_id' => $item_row['voucher_id']

        ]);
    }

// Convert the Array to a JSON String and echo it
    $someJSON = json_encode($someArray);
    echo $someJSON;
}
/*****************************START FROM ACCOUNT LEDGER*************************/



















?>