<?php
session_start();
include("../include/dbconnect.php");
include("../include/functions.php");


$pl_voucherId = clean_data($_POST['pl_voucher_id']);

try {
    $item_query = "SELECT m.voucher_id,
	m.voucher_date,
	d.stock_code,
	p.acct_name,
	m.discp,
	m.net_amt,
	m.adv_amt,
	m.net_payable,
	m.acct_id,
	i.description stock_name,
	d.color_id,
	d.size_id,
	d.qty,
	d.rate,
	d.itemtot,
	r.description color_name,
	s.size
	 FROM pl_invoice m 
LEFT JOIN pl_invoicedet d ON m.comp_id = d.comp_id and m.year_id = d.year_id and m.voucher_id = d.voucher_id
LEFT JOIN v_party p ON m.acct_id = p.acct_id
LEFT JOIN item i ON i.stock_code = d.stock_code
LEFT JOIN color r ON d.color_id = r.color_id
	LEFT JOIN size s ON d.size_id = s.size_id
WHERE d.voucher_id = '$pl_voucherId'";
    $item_result = $dbcon->prepare($item_query);
    $item_result->execute(array());
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}




// Create empty array to hold query results
$someArray = [];
// Loop through query and push results into $someArray;
while ($item_row = $item_result->fetch(PDO::FETCH_ASSOC)) {
    array_push($someArray, [
        'voucher_date'   => format_date_yyyy($item_row['voucher_date']),
        'acct_id'   => $item_row['acct_id'],
        'net_amt'   => round($item_row['net_amt']),
        'adv_amt'   => round($item_row['adv_amt']),
        'net_payable'   => round($item_row['net_payable']),

        'stock_code'   => $item_row['stock_code'],
        'stock_name'   => $item_row['stock_name'],
        'color_name'   => $item_row['color_name'],
        'color_id'   => $item_row['color_id'],
        'size'   => $item_row['size'],
        'size_id'   => $item_row['size_id'],
        'qty'   => round($item_row['qty']),
        'rate'   => round($item_row['rate']),
        'itemtot'   => round($item_row['itemtot'])
    ]);
}

// Convert the Array to a JSON String and echo it
$someJSON = json_encode($someArray);
echo $someJSON;
?>