<?php
session_start();
include("../include/dbconnect.php");
include("../include/functions.php");




try {
    $item_query = "SELECT i.stock_code, i.description, i.s_rate FROM item i order by i.stock_code";
    $item_result = $dbcon->prepare($item_query);
    $item_result->execute(array());
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}



// Create empty array to hold query results
$someArray = [];

// Loop through query and push results into $someArray;
while ($item_row = $item_result->fetch(PDO::FETCH_ASSOC)) {
    array_push($someArray, [
        'stock_code'   => $item_row['stock_code'],
        'description' => $item_row['description'],
        's_rate' => round($item_row['s_rate'])
    ]);
}

// Convert the Array to a JSON String and echo it
$someJSON = json_encode($someArray);
echo $someJSON;
?>