<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}

$comp_id =  $_SESSION["comp_id"];
$rep_id = clean_data($_GET['rep_id']);
$rep_name = find_value('reports', 'report_name', " and rep_id='$rep_id'");
?>


<?php include('header.php'); ?>
<title><?php echo $rep_name; ?> | <?php echo $row->acct_name; ?></title>
<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="reports">
                    Accounts</a>
            </li>
            <li class="breadcrumb-item active">Chart of Account</li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h4>Chart of Account</h4>
                                </div>
                                <div class="col-lg-6">

                                    <div class="d_text_align">
                                        <i class="fa fa-file-excel pull-right exportToExcel ml-2" data-toggle="tooltip" data-placement="top" title="Export to Excel"></i>


                                        <i class="fa fa-file-pdf pull-right exportToPDF" data-toggle="tooltip" data-placement="top" title="Export to PDF"></i>




                                    </div>
                                </div>
                            </div>



                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-hover table2excel">

                                <thead class="sticky-top">
                                    <tr>
                                        <th style="width: 10%">SR</th>
                                        <th style="width: 20%">Account ID</th>
                                        <th style="width: 25%">Account Name</th>
                                        <th style="width: 25%">Account Type</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    try {
                                        $nom_query = "SELECT n.acct_id, n.acct_name, t.acct_name acct_type_name, r.reg_name, n.address, 
                                                  n.email, n.phone,n.credit_limit, n.ntn, n.stax_no, c.city_name, s.acct_name sp_name
                                                    FROM
	                                                nom n
	                                                LEFT JOIN acct_type t ON n.acct_id = t.acct_id
	                                                LEFT JOIN regions r ON n.reg_id = r.reg_id 
	                                                LEFT JOIN city c ON c.city_id = n.city_id
	                                                LEFT JOIN sp s ON s.acct_id = n.sp_id
	                                                WHERE 1=1
                                                    ORDER BY n.acct_id ASC";
                                        $nom_result = $dbcon->prepare($nom_query);
                                        $nom_result->execute(array($comp_id));
                                    } catch (PDOException $e) {
                                        echo "Error : " . $e->getMessage();
                                    }


                                    $sr = 0;
                                    while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {
                                        $sr += 1;
                                        $bold = '';
                                        if (strlen($nom_row->acct_id) <= 6)
                                            $bold = '<b>';
                                    ?>
                                        <tr>
                                            <td><?php echo $sr; ?></td>
                                            <td class="btnSelect"><?php echo $bold;
                                                                    echo $nom_row->acct_id; ?></td>
                                            <td class="btnSelect"><?php echo $bold;
                                                                    echo $nom_row->acct_name; ?></a></td>
                                            <td class="btnSelect"><?php echo $nom_row->acct_type_name; ?></a></td>


                                        </tr>
                                    <?php
                                    }
                                    ?>
                                </tbody>
                            </table>




                        </div>
                    </div>
                </div>





            </div>



    </section>

</div>
















<?php include('footer.php'); ?>

<!----------------------------START JAVA SCRIPT---------------------------->
<script type="text/javascript">
    $(".exportToExcel").click(function() {
        $(".table2excel").table2excel({
            exclude: ".noExl",
            name: "Chart of Account",
            filename: "Chart Of Account" + new Date().toISOString().replace(/[\-\:\.]/g, "") + ".xls",
            fileext: ".xls",
            exclude_img: true,
            exclude_links: true,
            exclude_inputs: true
        });
    });

    $(".exportToPDF").click(function() {
        $(".table2excel").tableHTMLExport({

            type: 'pdf',
            orientation: 'p',
            filename: 'Chart of Account'


        });
    });
</script>

<!----------------------------END JAVA SCRIPT---------------------------->