<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $comm_invoice = clean_data($_GET['comm_invoice']);
        $rep_name = 'INVOICE';
        if ($comm_invoice=='Y'){
            $rep_name = 'INVOICE';
        }

        // Logo
        $this->Image('dist/tt_fitt/logo.png',5,6,60);
        $this->Image('dist/tt_fitt/iata.png',175,6,30);

        $this->Ln(10);
        $this->SetFont('Arial', 'B', 18);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(0,10, $rep_name,0,0,'C');
        $this->Ln(10);
//        $this->Ln(10);

    }

}


$pdf = new PDF();

$pdf->AddPage("P");


$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
$phone=find_value('company','phone'," and comp_id='$comp_id'");
$address=find_value('company','add_line1'," and comp_id='$comp_id'");
$city=find_value('company','city'," and comp_id='$comp_id'");
$ntn=find_value('company','ntn'," and comp_id='$comp_id'");
$license_no=find_value('company','license_no'," and comp_id='$comp_id'");

$qty_decimals=find_value('v_system','qty_decimals',"");

$pdf->SetFont('Arial', 'BIU', 24);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$v_id = clean_data($_GET['v_id']);

$comm_invoice = clean_data($_GET['comm_invoice']);
$f_ticket_recv5='d.ticket_recv5';
$f_itemtot='d.itemtot';
if ($comm_invoice=='Y'){
    $f_ticket_recv5='d.comm_ticket_recv5';
    $f_itemtot='d.comm_itemtot';
}

$and ="";
$and .= " and m.comp_id = '$comp_id'";

if (!empty($v_id)) {
    $and .= " and m.voucher_id = '$v_id'";
    $and .= " and m.year_id = '$year_id'";
}else{
    $and .= " and m.voucher_date between '$new_from_date' and '$new_to_date'";
}

try
{
    $voucher_query =  "SELECT   concat(m.comp_id,m.year_id,m.voucher_id) v_id,
                                m.voucher_id bill_no,
                                m.voucher_date,
                                p.phone,
                                p.acct_name party_name,
                                p.address,
                                p.city,
                                p.ntn,
                                p.stax_no,
                                p.cnic 
                        FROM sl_invoice m 
                        LEFT JOIN v_party p ON m.acct_id = p.acct_id
                        WHERE 1=1  $and
                        ORDER BY m.voucher_id
                       ";

//echo $voucher_query;
    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$num_rows = $voucher_result->rowCount();
$_SESSION["num_rows"] = $num_rows;

while ($report_row = $voucher_result->fetch(PDO::FETCH_ASSOC)) {

    $voucher_id=$report_row['voucher_id'];
    $v_id=$report_row['v_id'];

    $party_name = $report_row['party_name'];
    $p_address = $report_row['address'];
    $p_city = $report_row['city'];
    $p_phone = $report_row['phone'];

    $p_ntn = $report_row['ntn'];
    $p_stax_no = $report_row['stax_no'];
    $p_cnic = $report_row['cnic'];


    $pdf->Ln(10);

    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(150, 10, 'Invoice No: '. ($report_row['bill_no']), 0);
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(10);
    $pdf->Cell(5, 10, 'Invoice Date: '.format_date($report_row['voucher_date']).'', 0);
    $pdf->Ln(15);
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(70, 8, '', 0);
    $pdf->SetLeftMargin('10');
    $pdf->Ln(1);



    /***********************START SUPPLIER BLOCK******************/
    $pdf->SetFont('Arial', 'B', 14);

    $pdf->Cell(1);
    $pdf->setFillColor(230,230,230);
    $pdf->Cell(95, 10, 'SUPPLIER', 1,0,'C', true);
    $pdf->Cell(2);
    $pdf->setFillColor(230,230,230);
    $pdf->Cell(95, 10, 'BUYER', 1,1,'C', true);

    $pdf->SetFont('Arial', '', 8);
//SYPPLIER NAME
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Name:   ', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $comp_name, 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//BUYER NAME
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Name:', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $party_name, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//SUPPLIER ADDRESS
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Address:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $address, 0,1,'L');


    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Address:', 0,1,'L');


    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_address, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'City:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $city, 0,1,'L');


    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'City:', 0,1,'L');


    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_city, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER ADDRESS


//SUPPLIER PHONE
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Phone:', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, $phone, 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');


//BUYER PHONE
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'Phone:', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_phone, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//SUPPLIER NTN
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'NTN:', 0,1,'L');

//BUYER NTN
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'NTN:', 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, $ntn, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_ntn, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');




//SUPPLIER SALE TAX
    $pdf->Ln(5);
    $pdf->Cell(95, 0, 'Govt. Licence No:', 0,1,'L');
    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'S TAX#:', 0,1,'L');


    $pdf->Cell(25);
    $pdf->Cell(95, 0, $license_no, 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_stax_no, 0,1,'L');



    $pdf->Cell(22);
    $pdf->Cell(95, 0, '_____________________________________________', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');

//SUPPLIER CNIC
    $pdf->Ln(5);
    $pdf->Cell(95, 0, '', 0,1,'L');
    $pdf->Cell(12);
    $pdf->Cell(95, 0, '', 0,1,'L');
    $pdf->Cell(14);
    $pdf->Cell(95, 0, '', 0,1,'L');


//BUYER CNIC
    $pdf->Cell(95, 0, 'CNIC:', 0,1,'L');


    $pdf->Cell(97);
    $pdf->Cell(95, 0, 'CNIC:', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, $p_cnic, 0,1,'L');

    $pdf->Cell(12);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');
    $pdf->Cell(110);
    $pdf->Cell(95, 0, '____________________________________________________', 0,1,'L');



    /***********************END SUPPLIER BLOCK******************/

    /*****************END MASTER TABLE QUERY*****************/

    $pdf->SetFont('Arial', 'B', 8);

    $pdf->Ln(5);
    $pdf->Cell(1);
    $pdf->Cell(12, 8, 'Sr', 1);
    $pdf->Cell(100, 8, 'PARTICULARS', 1);
    $pdf->Cell(26, 8, 'TICKET NO', 1);
    $pdf->Cell(18, 8, 'Fare', 1, 0,'R');
    $pdf->Cell(18, 8, 'PSF', 1, 0,'R');
    $pdf->Cell(18, 8, 'Total', 1, 0,'R');

    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);

    $and .=" and (d.lineitem in('1','3','6','7','9','12'))";
    try
    {
        $vd_query =  "SELECT    m.voucher_id,
                                p.phone c_phone,
                                p.acct_name party_name,
                                p.address add_line1,
                                p.city,
                                p.ntn party_ntn,
                                p.stax_no party_stax_no,
                                p.cnic,
                            	d.pax_name,
                            	concat(d.pax_name,' ',d.particulars) particulars,
                                d.tax_pk,
                                d.ticket_no,
                                $f_ticket_recv5 psf,
                                ifnull($f_itemtot,0)-ifnull($f_ticket_recv5,0) rate,
                                $f_itemtot itemtot
                        FROM sl_invoice m 
                        LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id and m.voucher_id = d.voucher_id
                        LEFT JOIN v_party p ON m.acct_id = p.acct_id
                        LEFT JOIN v_item i ON d.stock_code = i.stock_code
                        LEFT JOIN nom n ON d.payable_id = n.acct_id
                        WHERE 1=1  $and
                        ORDER BY m.voucher_id, d.lineitem/1
                       ";
echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    $sr = "";
    $tot_rate=0;
    $tot_psf=0;
    $tot_itemtot=0;

    while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

        $tot_rate += $rd_row['rate'];
        $tot_psf += $rd_row['psf'];
        $tot_itemtot += $rd_row['itemtot'];

        $sr += 1;
        $_SESSION["sr"] = $sr;
        $pdf->Cell(1);
        $pdf->Cell(12, 8, $sr.'.', 1);
        $pdf->Cell(100, 8, $rd_row['particulars'], 1);
        $pdf->Cell(26, 8, $rd_row['ticket_no'], 1);
        $pdf->Cell(18, 8, format_number_pdf($rd_row['rate'],$amt_decimals), 1, 0,'R');
        $pdf->Cell(18, 8, format_number_pdf($rd_row['psf'],$amt_decimals), 1, 0,'R');
        $pdf->Cell(18, 8, format_number_pdf($rd_row['itemtot'],$amt_decimals), 1, 0,'R');

        $pdf->Ln(8);
    }

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(116);
    $pdf->Cell(20,8,'Total :',0,0,'R');
    $pdf->Cell(3);
    $pdf->Cell(18,8,format_number_pdf($tot_rate,$qty_decimals),0,0, 'R');
    $pdf->Cell(18,8,format_number_pdf($tot_psf,$amt_decimals),0,0, 'R');
    $pdf->Cell(18,8,format_number_pdf($tot_itemtot,$amt_decimals),0,0, 'R');

    $pdf->SetFont('Arial', '', 8);

    $pdf->Ln(5);

    $net_payable=$tot_itemtot;

    $comm_invoice = 'Y';
    $f_ticket_recv5='d.ticket_recv5';
    $f_itemtot='d.itemtot';
    if ($comm_invoice=='Y'){
        $f_ticket_recv5='d.comm_ticket_recv5';
        $f_itemtot='d.comm_itemtot';
    }

    $and =" and m.base_voucher_id='$v_id'";
    try
    {
        $vd_query =  "SELECT    m.voucher_id bill_no,
                                m.voucher_date,
                                p.phone c_phone,
                                p.acct_name party_name,
                                p.address add_line1,
                                p.city,
                                p.ntn party_ntn,
                                p.stax_no party_stax_no,
                                p.cnic,
                            	d.pax_name,
                            	concat(d.pax_name,' ',d.particulars) particulars,
                                d.tax_pk,
                                d.ticket_no,
                                $f_ticket_recv5 psf,
                                ifnull($f_itemtot,0)-ifnull($f_ticket_recv5,0) rate,
                                $f_itemtot itemtot
                        FROM sl_return m 
                        LEFT JOIN sl_returndet d ON m.comp_id = d.comp_id AND m.year_id = d.year_id and m.voucher_id = d.voucher_id
                        LEFT JOIN v_party p ON m.acct_id = p.acct_id
                        LEFT JOIN v_item i ON d.stock_code = i.stock_code
                        LEFT JOIN nom n ON d.payable_id = n.acct_id
                        WHERE 1=1 $and
                        ORDER BY m.voucher_id, d.lineitem/1
                       ";
//echo $vd_query;

        $vd_result = $dbcon->prepare($vd_query);
        $vd_result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }

    if ($vd_result->rowCount()>0) {


        $sr = "";
        $cnt=0;
        $tot_rate = 0;
        $tot_psf = 0;
        $tot_itemtot = 0;

        while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

            $cnt+=1;
            if ($cnt==1)
            {
                $pdf->Ln(5);
                $pdf->SetFont('Arial', 'BU', 12);
                $pdf->Cell(1);
                $pdf->Cell(0,10, 'REFUND INVOICE',0,0,'C');
//                $pdf->Cell(20, 8, 'REFUND:', 0, 0, '');
                $pdf->SetFont('Arial', '', 8);

                $pdf->Ln(8);

                $pdf->SetFont('Arial', '', 10);
                $pdf->Cell(150, 10, 'Invoice No: ' . ($rd_row['bill_no']), 0);
                $pdf->SetFont('Arial', '', 9);
                $pdf->Cell(10);
                $pdf->Cell(5, 10, 'Invoice Date: ' . format_date($rd_row['voucher_date']) . '', 0);
                $pdf->Ln(8);
            }
            $tot_rate += $rd_row['rate'];
            $tot_psf += $rd_row['psf'];
            $tot_itemtot += $rd_row['itemtot'];

            $sr += 1;
            $_SESSION["sr"] = $sr;
            $pdf->Cell(1);
            $pdf->Cell(12, 8, $sr . '.', 1);
            $pdf->Cell(100, 8, $rd_row['particulars'], 1);
            $pdf->Cell(26, 8, $rd_row['ticket_no'], 1);
            $pdf->Cell(18, 8, format_number_pdf($rd_row['rate'], $amt_decimals), 1, 0, 'R');
            $pdf->Cell(18, 8, format_number_pdf($rd_row['psf'], $amt_decimals), 1, 0, 'R');
            $pdf->Cell(18, 8, format_number_pdf($rd_row['itemtot'], $amt_decimals), 1, 0, 'R');

            $pdf->Ln(8);
        }

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(116);
        $pdf->Cell(20, 8, 'Total :', 0, 0, 'R');
        $pdf->Cell(3);
        $pdf->Cell(18, 8, format_number_pdf($tot_rate, $qty_decimals), 0, 0, 'R');
        $pdf->Cell(18, 8, format_number_pdf($tot_psf, $amt_decimals), 0, 0, 'R');
        $pdf->Cell(18, 8, format_number_pdf($tot_itemtot, $amt_decimals), 0, 0, 'R');

        $net_payable -=$tot_itemtot;
    }

    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(155);
    $pdf->Cell(20,8,'Net Payable :',0,0,'R');
    $pdf->Cell(18,8,format_number_pdf($net_payable,$amt_decimals),0,0, 'R');

    $pdf->Ln(8);
    $nw=new NumbersToWords();

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(15,8,'Amount : Rs. ',0);
    $pdf->SetFont('Arial', 'U', 8);
    $pdf->Cell(3);
    $pdf->Cell(50,8,strtoupper($nw->convert($net_payable)).' ONLY',0);

    $pdf->Ln(5);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(160);
    $pdf->Cell(15,8,'For '. $comp_name,0,0,'R');

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(172);
    $pdf->Cell(20,8,'Signatures:___________________________________',0,0, 'R');

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(172);
    $pdf->Cell(20,8,'Name:___________________________________',0,0, 'R');

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(147);
    $pdf->Cell(25);
    $pdf->Cell(20,8,'Designation:___________________________________',0,0, 'R');

    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(6);
    $pdf->Cell(20,8,'Acknowledgment:',0,0, 'R');

    $pdf->Ln(5);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(200,8,'I/We, the signatory as payer hereby acknowledges receipt of the ticket(s) mentioned above &
                    ',0,0, 'L');
    $pdf->Ln(5);
    $pdf->Cell(200,8,'hereby to pay all fares and charges of the said ticket(s) & also hereby indemnify and agree to be 
                    ',0,0, 'L');
    $pdf->Ln(5);
    $pdf->Cell(200,8,'jointly or solely liable with said payer for the said payments.
                    ',0,0, 'L');

    if ($_SESSION["num_rows"]>1)
        $pdf->AddPage("P");

}

$pdf->Output();
