<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");


        $login_page = find_value('v_system', 'login_page', '');




        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $from_date = date('d-m-Y', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $to_date = date('d-m-Y', $change_to_date);


        $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");

        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, 'Loading Daybook', 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(48, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(206, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(10, 8, 'Ser', 1,'C');
        $this->Cell(10, 8, 'V Type', 1, 0, 'C');
        $this->Cell(15, 8, 'R_#', 1, 0, 'C');
        $this->Cell(15, 8, 'Date', 1, 0, 'C');
        $this->Cell(50, 8, 'Party Name', 1, 0, 'L');
        $this->Cell(20, 8, 'Item', 1, 0, 'L');
        $this->Cell(50, 8, 'Brand', 1, 0, 'L');

        $this->Cell(15, 8, 'Qty', 1, 0,'R');
        $this->Cell(50, 8, 'Transfer', 1, 0,'L');
        $this->Cell(50, 8, 'Address', 1, 0,'L');


        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);

$rpt_type = clean_data($_GET['rpt_type']);


/*****************START MYSQL VARIABLES**************/

$comp_name = '';
/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

$and = '';
$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

if ($comp_id != "All") {

    $and .= " and v.comp_id = '$comp_id'";



} else {
    $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";


}

if ($rpt_type != "All") {

    $and .= " and substring(v.voucher_id,1,2) = '$rpt_type'";

}

$login_page = find_value('v_system', 'login_page', '');


try {
    $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
    v.voucher_type,
v.voucher_date,
v.party_name,
v.to_party_name,
p.address,
v.stock_code,
v.stock_name,
v.type_name,
v.rate,
v.bill_no,
v.qty

FROM v_loading v
LEFT JOIN v_item i on v.stock_code=i.stock_code
LEFT JOIN v_party p on v.to_party_id=p.acct_id
WHERE
		1 = 1 $and order by v.voucher_date, v.post_date";
    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = "";
$g_q_tot = '';
$g_amt = '';
$g_profit = '';

    while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {

    $sr += 1;

    $g_q_tot += $report_row['qty'];
    $g_amt += $report_row['amt'];
    $g_profit += $report_row['profit'];

    $pad='';
    if (strlen($report_row['stock_name'])>35)
        $pad='...';

        $pdf->Cell(1);
        $pdf->Cell(10, 8, $sr, 1);
        $pdf->Cell(10, 8, $report_row['voucher_type'], 1, 0, 'C');
        $pdf->Cell(15, 8, $report_row['bill_no'], 1, 0, 'C');
        $pdf->Cell(15, 8, format_date($report_row['voucher_date']), 1, 0, 'C');
        $pdf->Cell(50, 8, $report_row['party_name'], 1, 0, 'L');
        $pdf->Cell(20, 8, $report_row['stock_name'], 1, 0, 'L');
        $pdf->Cell(50, 8, $report_row['type_name'], 1, 0, 'L');
        $pdf->Cell(15, 8, format_number_pdf($report_row['qty'],0), 1, 0,'R');
        $pdf->Cell(50, 8, $report_row['to_party_name'], 1, 0, 'L');
        $pdf->Cell(50, 8, $report_row['address'], 1, 0, 'L');


    $pdf->Ln(8);
    
}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(10, 8, '', 1);
$pdf->Cell(10, 8, '', 1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(50, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(50, 8, 'Total : ', 1, 0,'R');
$pdf->Cell(15, 8, format_number_pdf($g_q_tot,0), 1, 0,'R');
$pdf->Cell(50, 8, '', 1);
$pdf->Cell(50, 8, '', 1);

$pdf->Output();
ob_end_flush();