<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("tcpdf/tcpdf.php");

if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
    exit();
}

date_default_timezone_set("Asia/Karachi");

/*****************START VARIABLES***************/
$_SESSION['voucher_type'] = clean_data($_GET['voucher_type']);
$voucher_type = clean_data($_SESSION['voucher_type']);
$comp_id = clean_data($_SESSION["comp_id"]);
$year_id = clean_data($_SESSION["year_id"]);

$comp_name = clean_data($_SESSION["COMP_NAME"]);
$phone = clean_data($_SESSION["phone"]);
$address = clean_data($_SESSION["address"]);

$s_date_formt =  find_value('v_system','date_format', '');
$currency_sign = find_value('v_system','currency_sign', '');
$amt_decimals = find_value('v_system','amt_decimals','');
$qty_decimals = find_value('v_system','qty_decimals', '');

$v_id = clean_data($_GET['v_id']);









/*****************END VARIABLES***************/




class PDF extends TCPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");
        /*****************START VARIABLES***************/
        $comp_id = clean_data($_SESSION["comp_id"]);
        $v_id= $_GET['v_id'];
        $year_id = clean_data($_SESSION["year_id"]);
        $address = clean_data($_SESSION["address"]);
        $phone = clean_data($_SESSION["phone"]);
        $comp_name = clean_data($_SESSION["COMP_NAME"]);


        /*****************START MYSQL MASTER TABLE QUERY*************************/




        $this->Rect(5, 5, 200, 287, 'D'); //For A4

        $this->setFillColor(0,148,96);
        $this -> SetY(5);    // set the cursor at Y position 5
        $this -> SetX(5);
        $this->Cell(200, 2, '', '0',0,'', true);
        $this->Ln(2);




        /*****************END MYSQL MASTER TABLE QUERY*************************/




    }






}


//$pdf = new PDF_AutoPrint();

$pdf = new PDF('P','mm','A4');
$pdf->AddPage();
//$pdf->AliasNbPages();

$able_font = TCPDF_FONTS::addTTFfont('tcpdf/fonts/pantonblackitaliccaps.ttf', 'TrueTypeUnicode', '', 32);


$pdf->SetFont($able_font, 'B', 12, '', false);
$pdf->Cell(60,10,'Purchase Invoice',0,0,'L');

$pdf->Cell(50);
$pdf->SetFillColor(220,220,220);




$login_page  = find_value("v_system", "login_page", " ");
if($login_page == 'login-at')
{

    $image_file = 'assets/img/logo/at/at_logo.png';
    $pdf->Image($image_file, '170', '10', 25, '25', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);


}
if($login_page == 'login-hm')
{

    $image_file = 'assets/img/logo/hm/logo_1.png';
    $pdf->Image($image_file, '170', '10', 30, '30', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);


}

if($login_page == 'login-arkt')
{

    $image_file = 'assets/img/logo/arkt/logo.png';
    $pdf->Image($image_file, '170', '12', 30, '30', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);


}


//$pdf->Image('assets/img/Final_logo.png','170','12','20','20','','');

$and = '';
$and .= " AND v.voucher_id = '$v_id'";
$and .= " and v.comp_id =  '$comp_id' ";
$and .= " and v.year_id =  '$year_id' ";



try
{
    $sl_detail_query =  "SELECT v.acct_id, v.voucher_id, v.bill_no, v.voucher_date, c.comp_name, c.add_line1,c.phone,c.email,
                              c.stax_no, c.ntn, p.acct_name party_name, p.address add_line1, c.phone c_phone, 
                                p.phone,  v.disc_amt,
	v.dc_amt,
	v.net_amt,
	v.adv_amt,
	v.net_payable,
       v.particulars,
       c.detail_one,
       c.add_line1
                        FROM pl_invoice v 
                        LEFT JOIN company c ON c.comp_id = v.comp_id
                        LEFT JOIN v_party p ON p.acct_id = v.acct_id
                        WHERE 1=1  $and
                        ORDER BY v.bill_no
                       ";
    $sl_detail_result = $dbcon->prepare($sl_detail_query);
    $sl_detail_result->execute(array( ));
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}

$num_rows = $sl_detail_result->rowCount();
$_SESSION["num_rows"] = $num_rows;
$rowm = $sl_detail_result->fetch(PDO::FETCH_ASSOC);
$voucherId =  $rowm['voucher_id'];




$pdf->Ln(30);
$pdf->SetFont($able_font, 'B', 8, '', false);
$pdf->Cell(50, 8, 'From:', '0',0,'L', '');
$pdf->Cell(20);
$pdf->Cell(50, 8, 'For:', '0',0,'L');
$pdf->Cell(20);
$pdf->SetFont($able_font,'',8);
$pdf->Cell(60,6,'Number',0,0,'L'); // Set Invoice Number
$pdf->SetX($pdf->GetX() - 40);
$pdf->Cell(60,6, $voucherId,0,0,'L'); // Set Invoice Number



$pdf->Ln(5);
$pdf->SetFont($able_font,'B',10);
$pdf->writeHTMLCell(60, 6, '', '', $rowm['party_name'], '', '', '');
$pdf->Ln(15);
$pdf->Cell(10);

$pdf->Cell(60,6,$rowm['comp_name'],0,0,'L'); // Set Client Name
$pdf->SetFont($able_font,'',8);
$pdf->Cell(10);
$pdf->Cell(60,6,'Date',0,0,'L');     //set voucher date
$pdf->SetX($pdf->GetX() - 40);
$pdf->Cell(60,6,format_date_yyyy($rowm['voucher_date'] ) ,0,0,'L');








$pdf->Ln(5);
$pdf->SetFont($able_font,'',8);
$pdf->Cell(60,6,$rowm['comp_name'],0,0,'L');  //Supplier Email Adress
$pdf->Cell(10);
$pdf->Cell(60,6,$rowm['detail_one'],0,0,'L');     //Buyer Email Address






$pdf->Ln(5);
$pdf->SetFont($able_font,'',8);
$pdf->Cell(60,6,$rowm['address'],0,0,'L');  //Supplier Adress
$pdf->Cell(10);
$pdf->Cell(60,6,$rowm['add_line1'],0,0,'L');     //Buyer Address



$pdf->Ln(5);
$pdf->SetFont($able_font,'',8);
$pdf->Cell(60,6,$rowm['phone'],0,0,'L');  //Supplier phone no
$pdf->Cell(10);
$pdf->Cell(60,6,$rowm['c_phone'],0,0,'L');     //Buyer phone no



$pdf->SetFont($able_font, 'B', 8);
$pdf->SetTextColor(0,0,0);
$pdf->Ln(1);
$pdf->SetDrawColor(0,0,0);
$pdf->SetFont($able_font, 'B', 8);
$pdf->Cell(70, 8, '', 0);
$pdf->SetLeftMargin('5');
$pdf->Ln(10);
/*****************END MASTER TABLE QUERY*****************/

$pdf->Cell(5);
$pdf->SetFont($able_font, 'B', 8, '', false);
$pdf->setFillColor(0,148,96);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(70, 8, 'Description', '0',0,'C', true);
$pdf->Cell(40, 8, 'Qty', '0',0,'C', true);
$pdf->Cell(40, 8, 'Price', '0',0,'C', true);
$pdf->Cell(40, 8, 'Amount', '0',0,'C', true);
$pdf->Ln(8);
$pdf->SetFont($able_font, '', 8);
$pdf->SetTextColor(0,0,0);

$and = " AND d.voucher_id = '$v_id'";
$and .= " AND d.comp_id = '$comp_id'";
$and .= " and d.year_id =  '$year_id' ";



try {
    $vd_query = "SELECT
	d.stock_code,
	d.particulars,
	d.qty,
	d.rate,
	d.voucher_id,
	i.description,
	d.qty*d.rate ex_value,
	d.itemtot,
	d.lineitem,
	c.comp_name,
	d.comp_id,
	d.discp,
	d.lineitem,
	d.discount
 	FROM pl_invoice v 
 	LEFT JOIN pl_invoicedet d ON v.voucher_id = d.voucher_id and v.comp_id = d.comp_id and v.year_id=d.year_id
	LEFT JOIN v_item i ON d.stock_code = i.stock_code

	LEFT JOIN company c ON c.comp_id = v.comp_id  
 	
 	WHERE 1=1 $and order by d.lineitem/1";
    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}




$sr = 0;
$g_tot = 0;
$tot_qty = 0;
$amount_tot = 0;
$qty_tot = 0;
while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $g_tot += $rd_row['amount'];
    $tot_qty += $rd_row['qty'];
    $v = $rd_row['voucher_id'];
    $qty_tot += $rd_row['qty'];
    $amount_tot  += $rd_row['itemtot'];

    $pdf->SetFont($able_font, 'B', 8, '', false);
    $pdf->Cell(5);

    $pdf->Cell(70, 8, $rd_row['description'], '0',0,'C');
    $pdf->Cell(40, 8, round($rd_row['qty']), '0','','C');
    $pdf->Cell(40, 8, format_number($rd_row['rate'], $amt_decimals), '0','','C');
    $pdf->Cell(40, 8, $currency_sign. ' '. format_number($rd_row['itemtot'], $amt_decimals), '0',0,'C');
    $pdf->Ln(7);
}



$pdf->SetDrawColor(0,148,96);
$pdf->Cell(5);
$pdf->Cell(190, 0, '', 'B',0,'', '');




$pdf->SetFont($able_font, 'B', 8, '', false);
/*$pdf->Cell(70, 8, '', 0);
$pdf->SetLeftMargin('5');*/
$pdf->Ln(3);
/*****************END MASTER TABLE QUERY*****************/




/***********************START SUB TOTAL************************/
$pdf->Cell(5);
$pdf->SetFont($able_font, 'B', 8, '', false);
$pdf->Cell(70, 8, 'Subtotal', '0',0,'C');

$pdf->Cell(40, 8, $tot_qty, '0',0,'C', '');
//$pdf->Cell(40, 8, 'Subtotal', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');

$pdf->Cell(40, 8, number_format($amount_tot,$amt_decimals), '0',0,'C', '');
/***********************END SUB TOTAL************************/




/***********************START INV DISC************************/
$pdf->Ln(10);
$pdf->Cell(5);
$pdf->Cell(70, 8, 'Inv Disc', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');
$pdf->Cell(40, 8, number_format($rowm['disc_amt'], $amt_decimals), '0',0,'C', '');
/***********************END INV DISC************************/



/***********************START FREIGHT TOTAL************************/
$pdf->Ln(5);
$pdf->Cell(5);
$pdf->Cell(70, 8, 'Freight', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');
$pdf->Cell(40, 8, number_format($rowm['dc_amt'], $amt_decimals), '0',0,'C', '');
/***********************END FREIGHT TOTAL************************/



/***********************START TOTAL************************/
$pdf->Ln(5);
$pdf->Cell(5);
$pdf->Cell(70, 8, 'Total', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');
$pdf->Cell(40, 8, number_format($rowm['net_amt'], $amt_decimals), '0',0,'C', '');
/***********************END TOTAL************************/



/***********************START PAYMENT************************/
$pdf->Ln(5);
$pdf->Cell(5);
$pdf->Cell(70, 8, 'Payment', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');
$pdf->Cell(40, 8, number_format($rowm['adv_amt'], $amt_decimals), '0',0,'C', '');
/***********************END PAYMENT************************/


$pdf->Ln(1);
$pdf->Cell(5);
$pdf->Cell(190, 8, '', 'B',0,'', '');
$pdf->Ln(10);



$pdf->Cell(5);
$pdf->SetFont($able_font, 'B', 8, '', false);


//$pdf->Cell(40, 8, $tot_qty, '0',0,'C', '');

$pdf->Cell(70, 8, 'Balance', '0',0,'C', '');
$pdf->Cell(40, 8, '', '0 ',0,'C');
$pdf->Cell(40, 8, '', '0',0,'C', '');
$pdf->Cell(40, 8, number_format($rowm['net_payable'], $amt_decimals), '0',0,'C', '');




$pdf->Ln(10);
$pdf->SetLeftMargin('10');
$pdf->Ln(5);
$pdf->SetFont($able_font, 'B', 8, '', false);
$pdf->Cell(100, 10, 'Terms & Conditions / Note:', 0, 0, 'L');



$pdf->Ln(10);
$pdf->SetFont($able_font, 'B', 7, '', false);
$pdf->MultiCell(100, 4, $rowm['particulars'], 0, 'L',  '');
$pdf->Ln(20);











ob_end_clean();
$pdf->Output();












