<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = 'ENQUIRY';

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(48, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->Cell(190, 10, 'Page '.$this->PageNo().'/{nb}', 0, 0, 'R');

        $this->Ln(10);
        $this->Line(11,37,287,37);

        /*****************END MASTER TABLE QUERY*****************/

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);

    }
}

$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$emp_id = clean_data($_SESSION["VALID_USER_ID"]);

$comp_id = $_GET['comp_id'];
$year_id = $_GET['year_id'];
$voucher_id = $_GET['v_id'];
$menu_id = $_GET['menu_id'];
$table = find_value("menu", 'menu_table', " and menu_id = '$menu_id'");
$tabledet = $table.'det';

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$and = '';
$and_comp = "";

$and .= " and m.comp_id = '$comp_id'";
$and .= " and m.year_id = '$year_id'";

if ($voucher_id != "All") {
    $and .= " and m.voucher_id = '$voucher_id'";
}

try
{
    $query =  "SELECT m.voucher_id, m.voucher_date, m.acct_id, p.acct_name, p.address, p.phone phone_no, p.fax_no, p.website, c.name cont_name, c.desig, c.email, c.phone_no cell_no
    FROM
        $table m
    LEFT JOIN nom p on m.acct_id=p.acct_id
    LEFT JOIN nom_cont c on (m.acct_id=c.acct_id and m.cont_id=c.cont_id)
    WHERE 1=1 $and
    order by m.voucher_id";

    //echo $query;

    $m_result = $dbcon->prepare($query);
    $m_result->execute();
}catch(PDOException $e){
    echo "Error : ". $e->getMessage();
}


$sr = "";

$no_row = 0;


while($mrow = $m_result->fetch(PDO::FETCH_ASSOC)) {
    $g_voucher_id = $mrow['voucher_id'];
    $g_acct_id = $mrow['acct_id'];
    $g_acct_name = $mrow['acct_name'];


    /***************END MYSQL QUERY FOR GROUP OPENING BALANCE*****************/

    ?>

    <?php

    try {
        $query="SELECT d.stock_code, d.qty, d.rate, d.itemtot, i.party_stock_code, i.description stock_name
                FROM $table m
                LEFT JOIN $tabledet d on m.comp_id=d.comp_id and m.year_id=d.year_id and m.voucher_id=d.voucher_id
                LEFT JOIN v_item i on d.stock_code=i.stock_code
                LEFT JOIN v_party p on m.acct_id=p.acct_id
                WHERE 1=1 $and
                  AND m.voucher_id = '$g_voucher_id' 
                order by d.lineitem";
//echo   $query;
        $d_result = $dbcon->prepare($query);
        $d_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $sr += 1;

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Voucher ID', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['voucher_id'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Date', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, format_date($mrow['voucher_date']), 0, 0, 'R');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Tender Due Date', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Client Name', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $g_acct_name, 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, '', 0, 0, 'R');
    $pdf->Cell(30, 8, '', 0, 0, 'R');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(82, 8, 'Client Ref No ', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Address', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['address'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, '', 0, 0, 'R');
    $pdf->Cell(30, 8, '', 0, 0, 'R');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(82, 8, 'Contact Name', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['cont_name'], 0);

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Designation', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['desig'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'UAN', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, '', 0, 0, 'R');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Telephone', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['phone_no'], 0);

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Fax No', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['fax_no'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Mobile No', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(30, 8, $mrow['cell_no'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Email', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['email'], 0);

    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(25, 8, 'Website', 0);
    $pdf->Cell(2, 8, ':', 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(25, 8, $mrow['website'], 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(80, 8, 'Remarks', 0, 0, 'R');
    $pdf->Cell(2, 8, ':', 0);

    $serno = 0;
    $qty_tot = 0;
    $itemtot_tot = 0;



    $pdf->Ln(8);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(1);
    $pdf->Cell(15, 8, 'Ser', 1);
    $pdf->Cell(20, 8, 'Item ID', 1, 0, 'C');
    $pdf->Cell(30, 8, 'Part No', 1, 0, 'C');
    $pdf->Cell(120, 8, 'Item Description', 1);

    $pdf->Cell(30, 8, 'Qty', 1, 0,'R');
    $pdf->Cell(30, 8, 'Rate', 1, 0,'R');
    $pdf->Cell(30, 8, 'Amount', 1, 0,'R');
    $pdf->Ln(0);
    $pdf->SetFont('Arial', '', 8);

    while ($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {
        $serno = $serno + 1;
        $qty_tot +=$report_row['qty'];
        $itemtot_tot +=$report_row['itemtot'];

        $pdf->Ln(8);
        $pdf->Cell(1);
        $pdf->Cell(15, 8, $serno, 1,'C');
        $pdf->Cell(20, 8, $report_row['stock_code'], 1, 0, 'C');
        $pdf->Cell(30, 8, $report_row['party_stock_code'], 1, 0, 'C');
        $pdf->Cell(120, 8, $report_row['stock_name'], 1);

        $pdf->Cell(30, 8, format_number_pdf($report_row['qty'],0), 1, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($report_row['rate'],0), 1, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($report_row['itemtot'],0), 1, 0,'R');

    }


        $pdf->Ln(8);
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(176);
        $pdf->Cell(10, 8, 'Total : ', 0, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($qty_tot,0), 1, 0,'R');
        $pdf->Cell(30, 8, '', 1, 0,'R');
        $pdf->Cell(30, 8, format_number_pdf($itemtot_tot,0), 1, 0,'R');
        $pdf->Ln(8);

}

$pdf->Output();
ob_end_flush();