<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_name = "Minimum Order Level Report";
        $rpt_type = clean_data($_GET['rpt_type']);

        $login_page = find_value('v_system', 'login_page', '');

        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $from_date = date('d-m-Y', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $to_date = date('d-m-Y', $change_to_date);


        $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");

        if($login_page == 'ke')
        {
            $comp_name=strtoupper('Muhammad Haseeb Ahmed');
        }

        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(178, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(180, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(50, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(110, 10, 'Date Upto : ' . ($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(10, 8, 'Ser', 1,'C');
        $this->Cell(50, 8, 'Stock Code', 1, 0, 'C');
        $this->Cell(100, 8, 'Stock Name', 1);

        $this->Cell(20, 8, 'Qty', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("P");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);
$stock_code = clean_data($_GET['stock_code']);
$cat_id = clean_data($_GET['cat_id']);
$mol = clean_data($_GET['mol']);

$rpt_type = clean_data($_GET['rpt_type']);

/*****************START MYSQL VARIABLES**************/

$comp_name = '';
/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

$and = '';
$filter = '';

if ($comp_id != "All") {
    $and .= " and v.comp_id = '$comp_id'";
}

if ($cat_id != "All") {
    $and .= " and i.cat_id = '$cat_id'";

    $filter .= 'Category:'.find_value('prod_cat','cat_name','');
}

if ($mol == "All") {
    $and .= " and v.qty>0";
}

if ($mol == "YES") {
    $and .= " and i.mol = 'Y' and v.qty<=i.mol_qty";
}

if ($mol == "NO") {
    $and .= " and i.mol = 'Y' and v.qty>i.mol_qty";
}



try {
    $msqlquery = "SELECT  distinct i.cat_id, c.cat_name
FROM
(
SELECT 
v.stock_code,
sum(ifnull(db_qty,0)-ifnull(cr_qty,0)) qty
FROM
	v_p_vouchers v
	WHERE
		voucher_date <= '$new_to_date'
GROUP BY v.stock_code
) v
left join item i on v.stock_code=i.stock_code
left join prod_cat c on i.cat_id=c.cat_id
where 1=1 $and
";



    $m_result = $dbcon->prepare($msqlquery);
    $m_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$g_q_tot = '';
$g_amt = '';
$g_profit = '';

while ($m_row = $m_result->fetch(PDO::FETCH_ASSOC)) {
    $cat_id = $m_row['cat_id'];

    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(1);
    $pdf->Cell(180, 8, $m_row['cat_name'], 0);
    $pdf->Ln(8);
    $pdf->SetFont('Arial', '', 8);

    /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/
    try {
        $msqlquery = "SELECT  concat(
		i.stock_code,
		CONVERT ( IF ( ( i.party_stock_code <> '' ), ' - ', '' ) USING latin1 ),
		`i`.`party_stock_code` 
	) AS stock_code, i.description stock_name, i.unit, i.mol_qty, v.qty
FROM
(
SELECT 
v.stock_code,
sum(ifnull(db_qty,0)-ifnull(cr_qty,0)) qty
FROM
	v_p_vouchers v
	WHERE
		voucher_date <= '$new_to_date'
GROUP BY v.stock_code
) v
left join item i on v.stock_code=i.stock_code
where 1=1 $and and i.cat_id='$cat_id'
";

//            echo $msqlquery;

        $q_result = $dbcon->prepare($msqlquery);
        $q_result->execute();
    } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
    }

    $sr = "";

    while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {


        $sr += 1;

        $g_q_tot += $report_row['qty'];

        $pad = '';
        if (strlen($report_row['stock_name']) > 35)
            $pad = '...';

        $pdf->Cell(1);
        $pdf->Cell(10, 8, $sr, 1);
        $pdf->Cell(50, 8, $report_row['stock_code'], 1, 0, 'L');
        $pdf->Cell(100, 8, substr($report_row['stock_name'], 0, 35) . $pad, 1);


        $pdf->Cell(20, 8, format_number_pdf($report_row['qty'], 0), 1, 0, 'R');


        $pdf->Ln(8);
    }
}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(160, 8, 'Total : ', 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($g_q_tot,0), 1, 0,'R');

$pdf->Output();
ob_end_flush();