<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
    exit();
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rpt_type = clean_data($_GET['rpt_type']);



        $login_page = find_value('v_system', 'login_page', '');




        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $from_date = date('d-m-Y', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $to_date = date('d-m-Y', $change_to_date);
        $s_comp_id = clean_data($_SESSION["comp_id"]);
        if ($comp_id != "All") {
            $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
            $comp_detail_one = find_value('company', 'detail_one', " and comp_id = '$s_comp_id'");

        }
        $this->AddFont('Panton','','pantonblackitaliccaps.php');

        $run_time =date('l, F jS, Y H:i:s A');


        $login_page  = find_value("v_system", "login_page", " ");
        if($login_page == 'login-at')
        {

            $image_file = 'assets/img/logo/at/at_logo.png';
            $this->Image($image_file, '20', '8', 30, '30', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);


            $image_filee = 'assets/img/logo/at/seal.png';
            //$this->Image($image_filee, '10', '', 28, '25', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);
            $this->Image($image_filee, '250', '10', 28, '25', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);


        }


        $this->SetFont('Panton', '', 30);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Panton', '', 10);
        $this->Cell(278, 10, ($comp_detail_one), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, 'Sale Daybook by Items', 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(52, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(190, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(10, 8, 'Ser', 1,'C');
        $this->Cell(20, 8, 'Voucher ID', 1, 0, 'C');

        $this->Cell(15, 8, 'Date', 1, 0, 'C');

        $this->Cell(20, 8, 'Stock Code', 1, 0, 'C');
        $this->Cell(100, 8, 'Stock Name', 1);

        $this->Cell(15, 8, 'Qty', 1, 0,'R');
        $this->Cell(20, 8, 'Rate', 1, 0,'R');



        $this->Cell(20, 8, 'Cost Price', 1, 0,'R');

        $this->Cell(20, 8, 'Amount', 1, 0,'R');

        $this->Cell(20, 8, 'Profit', 1, 0, 'R');
        $this->Cell(20, 8, 'Profit %', 1, 0, 'R');

        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);

$rpt_type = clean_data($_GET['rpt_type']);


/*****************START MYSQL VARIABLES**************/

$comp_name = '';
/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

$and = '';
$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

if ($comp_id != "All") {

    $and .= " and v.comp_id = '$comp_id'";



} else {
    $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";


}

if ($rpt_type != "All") {

    $and .= " and substring(v.voucher_id,1,2) = '$rpt_type'";

}

$login_page = find_value('v_system', 'login_page', '');


try {
    $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
       v.year_id,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.cr_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cr_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		order by v.voucher_date, v.voucher_id,v.lineitem/1";
    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = 0;
$g_q_tot = 0;
$g_amt = 0;
$g_profit = 0;

while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {

    $sr += 1;

    $g_q_tot += $report_row['qty'];
    $g_amt += $report_row['amt'];
    $g_profit += $report_row['profit'];

    $profit_margin = intval($report_row['profit'] * 100 / $report_row['amt']);

    $pad='';
    if (strlen($report_row['stock_name'])>35)
        $pad='...';

    $pdf->Cell(1);
    $pdf->Cell(10, 8, $sr, 1);
    $pdf->Cell(20, 8, $report_row['voucher_id'], 1, 0, 'C');

    $pdf->Cell(15, 8, format_date($report_row['voucher_date']), 1, 0, 'C');

    $pdf->Cell(20, 8, $report_row['stock_code'], 1, 0, 'C');
    $pdf->Cell(100, 8, substr($report_row['stock_name'],0,35).$pad, 1);


    $pdf->Cell(15, 8, format_number_pdf($report_row['qty'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($report_row['rate'],0), 1, 0,'R');

    $pdf->Cell(20, 8, format_number_pdf($report_row['cost_price'], 0), 1, 0, 'R');

    $pdf->Cell(20, 8, format_number_pdf($report_row['amt'],0), 1, 0,'R');

    $pdf->Cell(20, 8, format_number_pdf($report_row['profit'], 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($profit_margin, 0), 1, 0, 'R');



    $pdf->Ln(8);

}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(1);
$pdf->Cell(10, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(15, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(100, 8, 'Total:', 1, 0,'R');
$pdf->Cell(15, 8, format_number_pdf($g_q_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, '', 1, 0,'R');
$pdf->Cell(20, 8, '', 1, 0,'R');


$pdf->Cell(20, 8, format_number_pdf($g_amt,0), 1, 0,'R');

$pdf->Cell(20, 8,format_number_pdf($g_profit,0), 1, 0,'R');

$pdf->Cell(20, 8,'', 1, 0,'R');




$pdf->Output();
ob_end_flush();