<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");




        $login_page = find_value('v_system', 'login_page', '');




        $comp_id = $_GET['comp_id'];


        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $from_date = date('d-m-Y', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $to_date = date('d-m-Y', $change_to_date);

        if ($comp_id != "All") {
            $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");

        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 35);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', '', 25);
        $this->Cell(278, 10, 'Sale Status', 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 12);
        $this->Cell(278, 10, $from_date . ' - '. $to_date, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(52, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(190, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
        $this->Ln(10);

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(5);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(10, 8, 'Ser', 1,'C');
        $this->Cell(160, 8, 'Bill Type', 1, 0, 'C');
        $this->Cell(100, 8, 'Amount', 1, 0, 'C');

        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',10);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);

$bill_type = clean_data($_GET['bill_type']);




/*****************START MYSQL VARIABLES**************/

$comp_name = '';
/*************START FINDE COMPANY NAME***************/
if ($comp_id != "All") {

    $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
}
else
{
    $comp_name = find_value('v_system', 'comp_name', "");

}
/*************END FINDE COMPANY NAME*****************/

$and = '';
$and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

if ($comp_id != "All") {

    $and .= " and v.comp_id = '$comp_id'";



} else {
    $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";


}

if ($bill_type != "All") {
    $and .= " and (v.bill_type = '$bill_type')";
}
$login_page = find_value('v_system', 'login_page', '');


try {
    $msqlquery = "SELECT
       v.bill_type,
       p.acct_name,
       sum(if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)) amt
       FROM v_p_vouchers v
           LEFT JOIN v_party p on v.bill_type = p.acct_id
	        WHERE
		    1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		    GROUP BY v.bill_type
            order by v.voucher_date, v.voucher_id,v.lineitem/1 ";
    $q_result = $dbcon->prepare($msqlquery);
    $q_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = "";
$g_q_tot = '';
$g_amt = '';
$g_profit = '';

while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {

    $sr += 1;

    $g_q_tot += $report_row['amt'];
    $g_amt += $report_row['amt'];
    $g_profit += $report_row['profit'];

    $pad='';
    if (strlen($report_row['stock_name'])>35)
        $pad='...';

    $pdf->Cell(1);
    $pdf->Cell(10, 8, $sr, 1);
    $pdf->Cell(160, 8, $report_row['acct_name'], 1, 0, 'C');
    $pdf->Cell(100, 8, $report_row['amt'], 1, 0, 'C');



    $pdf->Ln(8);

}

$pdf->SetFont('Arial', 'B', 10);

$pdf->Cell(1);
$pdf->Cell(170, 8, 'Total : ', 1, 0,'R');
$pdf->Cell(100, 8, format_number_pdf($g_amt,0), 1, 0,'C');



$pdf->Output();
ob_end_flush();