<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


/*****************START VARIABLES***************/

/*****************END VARIABLES***************/


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {

        // Logo



        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $comp_id = clean_data($_GET['comp_id']);
        $acct_id = clean_data($_GET['acct_id']);

        $comp_name='';
        if ($comp_id != "All")
            $comp_name = find_value('company','comp_name'," and comp_id='$comp_id' ");

        $acct_name = find_value('nom','acct_name'," and acct_id='$acct_id' ");

        /*****************START MASTER TABLE QUERY*****************/

        /*****************START VARIABLES***************/
        include("include/dbconnect.php");


        date_default_timezone_set("Asia/Karachi");

        $this->SetFont('Arial', '', 10);


        $this->Cell(150, 10, 'Due Invoices : ' . $acct_name . ' - ' . $comp_name, 0);
        $this->SetFont('Arial', '', 9);
        $this->Cell(67);
        $this->Cell(5, 10, 'Report printed on : ' . date('d-m-Y h:i:s a'), 0);
        $this->Ln(15);
        $this->SetFont('Arial', 'B', 11);
        $this->Cell(70, 8, '', 0);
        $this->SetLeftMargin('2');
        $this->Ln(1);


        /*****************END MASTER TABLE QUERY*****************/


        $this->SetFont('Arial', 'B', 8);

        $this->Cell(10);
        $this->Cell(6, 8, 'Sr', 1);
        $this->Cell(12, 8, 'BILL#', 1);
        $this->Cell(60, 8, 'CUSTOMER NAME', 1);
        $this->Cell(20, 8, 'SALEMAN', 1);
        $this->Cell(110, 8, 'ITEMS', 1);
        $this->Cell(20, 8, 'AMOUNT', 1, 0,'R');
        $this->Cell(20, 8, 'RECEIVED', 1, 0,'R');
        $this->Cell(20, 8, 'BALANCE', 1, 0,'R');
        $this->Cell(10, 8, 'DAYS', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);



    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().' / {nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");


    $comp_id =  $_SESSION["comp_id"];
    $bal = 0;


    $and = " and m.comp_id = '$comp_id'";

        $vd_query  = "SELECT DISTINCT m.voucher_id, m.voucher_date,  datediff(CURDATE(),m.voucher_date) age, m.bill_no, 
                                  concat(p.acct_name,concat(if(m.customer_name='','',' / ')), m.customer_name) acct_name,
                                    ifnull(m.net_amt,0) net_amt, 
                                    ifnull(m.adv_amt,0)+ifnull(r.rec_amt,0) rec_amt,
                                    ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(r.rec_amt,0) bal_amt, 
                                    m.comp_id,  m.posted, m.disc_amt, substring(f_sl_invoice_products(m.comp_id,'',m.voucher_id),1,65) items, sp.acct_name sp_name
FROM sl_invoice m
LEFT JOIN (select v_no, sum(credit) rec_amt from voucherdet where v_no<>'' group by v_no) r on m.bill_no=r.v_no
LEFT JOIN v_party p on m.acct_id=p.acct_id
LEFT JOIN sp on m.sp_id=sp.acct_id
WHERE ifnull(m.net_amt,0)-ifnull(m.adv_amt,0)-ifnull(r.rec_amt,0)>0  $and  
ORDER BY datediff(CURDATE(),m.voucher_date) desc";

#echo $vd_query;

try
{
    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = 0;
$net_amt_tot = 0;
$rec_amt_tot = 0;
$bal_amt_tot = 0;
while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {

    $net_amt_tot += $rd_row['net_amt'];
    $rec_amt_tot += $rd_row['rec_amt'];
    $bal_amt_tot += $rd_row['bal_amt'];

    $sr += 1;
    $pdf->Cell(10);
    $pdf->Cell(6, 8, $sr, 1);
    $pdf->Cell(12, 8, ($rd_row['bill_no']), 1);
    $pdf->Cell(60, 8, ($rd_row['acct_name']), 1);
    $pdf->Cell(20, 8, ($rd_row['sp_name']), 1);
    $pdf->Cell(110, 8, ($rd_row['items']), 1);
    $pdf->Cell(20, 8, format_number_pdf($rd_row['net_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['rec_amt'],0), 1, 0,'R');
    $pdf->Cell(20, 8, format_number_pdf($rd_row['bal_amt'],0), 1, 0,'R');
    $pdf->Cell(10, 8, ($rd_row['age']), 1, 0,'R');

    $pdf->Ln(8);
}

$pdf->SetFont('Arial', 'B', 8);

$pdf->Cell(10);
$pdf->Cell(6, 8, '', 1);
$pdf->Cell(12, 8, '', 1);
$pdf->Cell(60, 8, '', 1);
$pdf->Cell(20, 8, '', 1);
$pdf->Cell(110, 8, 'Total : ', 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($net_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($rec_amt_tot,0), 1, 0,'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt_tot,0), 1, 0,'R');



$pdf->Output();