<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $comp_id = clean_data($_SESSION["comp_id"]);
        $rep_name = 'Supply Register';

        $date_from = date('d.m.Y');
        if (isset($_GET['from_date']))
        $date_from = $_GET['from_date'];

        $date_to = date('d.m.Y');
        if (isset($_GET['to_date']))
        $date_to = $_GET['to_date'];


        $comp_name=find_value('company','comp_name'," and comp_id='$comp_id'");


        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, $comp_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', '', 8);
        $this->Cell(278, 10, $date_from .' To ' . $date_to, 0, 0, 'R');

        /*****************END MASTER TABLE QUERY*****************/
        $this->Ln(10);

        $this->Cell(1);
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(13, 8, 'Date', 1,'C');
        $this->Cell(12, 8, 'Inv No', 1,'C');
        $this->Cell(48, 8, 'Party Name', 1);
        $this->Cell(48, 8, 'Product Name', 1);

        $this->Cell(20, 8, 'Qty', 1, 0,'R');
        $this->Cell(10, 8, 'Rate', 1, 0,'R');
        $this->Cell(20, 8, 'Ex. Value', 1, 0,'R');
        $this->Cell(10, 8, 'R %', 1, 0,'C');
        $this->Cell(20, 8, 'SaleTax', 1, 0,'R');
        $this->Cell(10, 8, 'Add %', 1, 0,'C');
        $this->Cell(20, 8, 'Additional', 1, 0,'R');
        $this->Cell(10, 8, 'Tax %', 1, 0,'C');
        $this->Cell(20, 8, 'Total Tax', 1, 0,'R');
        $this->Cell(20, 8, 'Amount', 1, 0,'R');
        $this->Ln(8);
        $this->SetFont('Arial', '', 8);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}


$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");

$comp_id = clean_data($_SESSION["comp_id"]);

$from_date = clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$and = "";
$and .= " AND m.comp_id = '$comp_id'";

$and .= " and m.voucher_date between '$new_from_date' and '$new_to_date'";


try
{
    $vd_query =  "SELECT 
    if(m.bill_no<>'', m.bill_no,m.voucher_id) inv_no, 
    m.voucher_date,
    p.acct_name party_name,
	d.stock_code,
	d.particulars,
	d.qty,
	d.rate,
	d.voucher_id,
	i.description prod_name,
	d.qty*d.rate ex_value,
	d.itemtot,
	d.lineitem,
	c.comp_name,
	d.comp_id,
	d.discp,
	d.lineitem,
	d.discount,
	d.sharing,
	d.avg_rate,
	d.staxp,
	d.add_staxp,
	d.stax_rate,
    ifnull(d.staxp,0)-ifnull(d.add_staxp,0) r_staxp,
    ifnull(d.stax,0)-ifnull((d.qty*d.rate)*d.add_staxp*.01,0) r_stax,
    ifnull((d.qty*d.rate)*d.add_staxp*.01,0) add_stax,
    d.stax
 	FROM sl_invoice m 
 	LEFT JOIN sl_invoicedet d ON m.voucher_id = d.voucher_id and m.comp_id = d.comp_id
	LEFT JOIN item i ON d.stock_code = i.stock_code
    LEFT JOIN v_party p ON m.acct_id = p.acct_id  

	LEFT JOIN company c ON c.comp_id = m.comp_id  
 	
 	WHERE 1=1  $and
    ORDER BY m.voucher_date, if(m.bill_no<>'', m.bill_no,m.voucher_id), d.lineitem";
    //echo $vd_query;
    $vd_result = $dbcon->prepare($vd_query);
    $vd_result->execute(array());
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


$sr = "";
$tot_ex_value=0;
$tot_r_stax=0;
$tot_add_stax=0;
$tot_stax=0;
$tot_r_stax=0;
$tot_itemtot=0;
$tot_qty=0;


$inv_no='';

$p_inv_no='';
$p_party_name='';

$p_inv_qty='N';

$voucher_date='';

$inv_ser_no=0;
$inv_ser = 0;

$date_tot_inv=0;
$date_ser = 0;
$date_qty=0;


$g_ser=0;
$g_ser = 0;
$g_qty=0;
$g_ex_value = 0;
$g_r_stax = 0;
$g_add_stax = 0;
$g_stax = 0;
$g_itemtot = 0;
$g_tot_inv=0;

while ($rd_row = $vd_result->fetch(PDO::FETCH_ASSOC)) {


    $p_inv_no='';
    $p_party_name='';
    if ($inv_no<>$rd_row['inv_no']){
        $inv_no=$rd_row['inv_no'];
        $p_inv_no=$inv_no;
        $p_party_name=$rd_row['party_name'];
        $date_tot_inv +=1;
        $g_tot_inv +=1;

        if ($inv_ser > 0){
            $p_inv_qty='N';
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->Cell(1);
            $pdf->Cell(13, 8, '', 1, 0);
            $pdf->Cell(12, 8, '', 1, 0);
            $pdf->Cell(48, 8, '', 1, 0);
            $pdf->Cell(48, 8, 'Invoice Total: ', 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($inv_qty,3), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_ex_value,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_r_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_add_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_stax,0), 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($inv_itemtot,0), 1, 0,'R');
            $pdf->SetFont('Arial', '', 8);
            $pdf->Ln(8);
        }
            $inv_ser = 0;
            $inv_qty=0;
            $inv_ex_value = 0;
            $inv_r_stax = 0;
            $inv_add_stax = 0;
            $inv_stax = 0;
            $inv_itemtot = 0;
    }

    $p_voucher_date='';

    if ($voucher_date<>$rd_row['voucher_date']){
        $voucher_date=$rd_row['voucher_date'];
        $p_voucher_date=format_date($voucher_date);

        if ($date_ser > 0){
            $p_inv_qty='N';
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->setFillColor(230,230,230);
            $pdf->Cell(1);
            $pdf->Cell(13, 8, '', 1, 0, 0, true);
            $pdf->Cell(12, 8, '', 1, 0, 0, true);
            $pdf->Cell(48, 8, '', 1, 0, 0, true);
            $pdf->Cell(48, 8, 'Date Total: '. $date_tot_inv, 1, 0,'R', true);
            $pdf->Cell(20, 8, format_number_pdf($date_qty,3), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_ex_value,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_r_stax,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_add_stax,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_stax,0), 1, 0,'R', true);
            $pdf->Cell(20, 8, format_number_pdf($date_itemtot,0), 1, 0,'R', true);
            $pdf->SetFont('Arial', '', 8);
            $pdf->Ln(8);
        }

            $date_tot_inv=0;
            $date_ser = 0;
            $date_qty =0;
            $date_ex_value = 0;
            $date_r_stax = 0;
            $date_add_stax = 0;
            $date_stax = 0;
            $date_itemtot = 0;

    }

    $inv_qty += $rd_row['qty'];
    $inv_ex_value += $rd_row['ex_value'];
    $inv_r_stax += $rd_row['r_stax'];
    $inv_add_stax += $rd_row['add_stax'];
    $inv_stax += $rd_row['stax'];
    $inv_itemtot += $rd_row['itemtot'];

    $date_qty += $rd_row['qty'];
    $date_ex_value += $rd_row['ex_value'];
    $date_r_stax += $rd_row['r_stax'];
    $date_add_stax += $rd_row['add_stax'];
    $date_stax += $rd_row['stax'];
    $date_itemtot += $rd_row['itemtot'];

    $g_qty += $rd_row['qty'];
    $g_ex_value += $rd_row['ex_value'];
    $g_r_stax += $rd_row['r_stax'];
    $g_add_stax += $rd_row['add_stax'];
    $g_stax += $rd_row['stax'];
    $g_itemtot += $rd_row['itemtot'];


    $sr += 1;
    $inv_ser += 1;
    $date_ser += 1;

    if ($p_inv_qty=='N'){
        $pdf->Cell(1);
        $pdf->Cell(13, 8, $p_voucher_date, 1);
        $pdf->Cell(12, 8, $p_inv_no, 1);
        $pdf->Cell(48, 8, $p_party_name, 1);
        $pdf->Cell(48, 8, $rd_row['prod_name'], 1);
        $pdf->Cell(20, 8, format_number($rd_row['qty'],3), 1, 0,'R');
        $pdf->Cell(10, 8, format_number($rd_row['rate'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number($rd_row['ex_value'],0), 1, 0,'R');
        $pdf->Cell(10, 8, format_number_pdf($rd_row['r_staxp'],0), 1, 0,'C');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['r_stax'],0), 1, 0,'R');
        $pdf->Cell(10, 8, format_number_pdf($rd_row['add_staxp'],0), 1, 0,'C');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['add_stax'],0), 1, 0,'R');
        $pdf->Cell(10, 8, format_number_pdf($rd_row['staxp'],0), 1, 0,'C');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['stax'],0), 1, 0,'R');
        $pdf->Cell(20, 8, format_number_pdf($rd_row['itemtot'],0), 1, 0,'R');

    }

    $pdf->Ln(8);
    
}

        $date_tot_inv +=1;

            $pdf->SetFont('Arial', 'B', 8);
            $pdf->Cell(1);
            $pdf->Cell(13, 8, '', 1, 0);
            $pdf->Cell(12, 8, '', 1, 0);
            $pdf->Cell(48, 8, '', 1, 0);
            $pdf->Cell(48, 8, 'Invoice Total:', 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($inv_qty,3), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_ex_value,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_r_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_add_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($inv_stax,0), 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($inv_itemtot,0), 1, 0,'R');

            $pdf->Ln(8);
            $pdf->Cell(1);
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->setFillColor(230,230,230);
            $pdf->Cell(13, 8, '', 1, 0, 0, true);
            $pdf->Cell(12, 8, '', 1, 0, 0, true);
            $pdf->Cell(48, 8, '', 1, 0, 0, true);
            $pdf->Cell(48, 8, 'Date Total: '. $date_tot_inv, 1, 0,'R', true);
            $pdf->Cell(20, 8, format_number_pdf($date_qty,3), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_ex_value,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_r_stax,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_add_stax,0), 1, 0,'R', true);
            $pdf->Cell(10, 8, '', 1, 0, 0, true);
            $pdf->Cell(20, 8, format_number_pdf($date_stax,0), 1, 0,'R', true);
            $pdf->Cell(20, 8, format_number_pdf($date_itemtot,0), 1, 0,'R', true);

            $pdf->Ln(8);
            $pdf->Cell(1);
            $pdf->Cell(13, 8, '', 1, 0);
            $pdf->Cell(12, 8, '', 1, 0);
            $pdf->Cell(48, 8, '', 1, 0);
            $pdf->Cell(48, 8, 'Grand Total: '.$g_tot_inv, 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($g_qty,3), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($g_ex_value,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($g_r_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($g_add_stax,0), 1, 0,'R');
            $pdf->Cell(10, 8, '', 1, 0);
            $pdf->Cell(20, 8, format_number_pdf($g_stax,0), 1, 0,'R');
            $pdf->Cell(20, 8, format_number_pdf($g_itemtot,0), 1, 0,'R');

$pdf->Output();