<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $period = clean_data($_GET['period']);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
        }

        if($period=='Monthly') {
            $x_center=330;
            $x_period=227;
            $x_page=283;

        }else{
            $x_center=550;
            $x_period=465;
            $x_page=521;

        }
        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell($x_center, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell($x_center, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);


        $this->SetFont('Arial', 'B', 8);
        $this->Cell($x_page);
        $this->Cell(50,10,'Page : '.$this->PageNo().' / {nb}',0,0,'L');
        $this->Ln(5);

        $this->SetFont('Arial', 'I', 8);
        $this->Cell(48, 10, 'Report Run on : '. $run_time, 0, 0, 'L');
        $this->SetFont('Arial', 'B', 8);

        $this->Cell($x_period);
        $this->Cell(53, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');

        $this->Ln(10);

//        $period='Monthly';

        if($period=='Monthly') {
            $this->Cell(80, 10, 'HEAD', 1, 0, 'L');
            $this->Cell(20, 10, 'JAN', 1, 0, 'R');
            $this->Cell(20, 10, 'FEB', 1, 0, 'R');
            $this->Cell(20, 10, 'MAR', 1, 0, 'R');
            $this->Cell(20, 10, 'APR', 1, 0, 'R');
            $this->Cell(20, 10, 'MAY', 1, 0, 'R');
            $this->Cell(20, 10, 'JUN', 1, 0, 'R');
            $this->Cell(20, 10, 'JUL', 1, 0, 'R');
            $this->Cell(20, 10, 'AUG', 1, 0, 'R');
            $this->Cell(20, 10, 'SEP', 1, 0, 'R');
            $this->Cell(20, 10, 'OCT', 1, 0, 'R');
            $this->Cell(20, 10, 'NOV', 1, 0, 'R');
            $this->Cell(20, 10, 'DEC', 1, 0, 'R');
            $this->Cell(20, 10, 'TOTAL', 1, 0, 'R');
        }else{
            $this->Cell(80, 10, 'HEAD', 1, 0, 'L');
            $this->Cell(15, 10, '01', 1, 0, 'R');
            $this->Cell(15, 10, '02', 1, 0, 'R');
            $this->Cell(15, 10, '03', 1, 0, 'R');
            $this->Cell(15, 10, '04', 1, 0, 'R');
            $this->Cell(15, 10, '05', 1, 0, 'R');
            $this->Cell(15, 10, '06', 1, 0, 'R');
            $this->Cell(15, 10, '07', 1, 0, 'R');
            $this->Cell(15, 10, '08', 1, 0, 'R');
            $this->Cell(15, 10, '09', 1, 0, 'R');
            $this->Cell(15, 10, '10', 1, 0, 'R');
            $this->Cell(15, 10, '11', 1, 0, 'R');
            $this->Cell(15, 10, '12', 1, 0, 'R');
            $this->Cell(15, 10, '13', 1, 0, 'R');
            $this->Cell(15, 10, '14', 1, 0, 'R');
            $this->Cell(15, 10, '15', 1, 0, 'R');
            $this->Cell(15, 10, '16', 1, 0, 'R');
            $this->Cell(15, 10, '17', 1, 0, 'R');
            $this->Cell(15, 10, '18', 1, 0, 'R');
            $this->Cell(15, 10, '19', 1, 0, 'R');
            $this->Cell(15, 10, '20', 1, 0, 'R');
            $this->Cell(15, 10, '21', 1, 0, 'R');
            $this->Cell(15, 10, '22', 1, 0, 'R');
            $this->Cell(15, 10, '23', 1, 0, 'R');
            $this->Cell(15, 10, '24', 1, 0, 'R');
            $this->Cell(15, 10, '25', 1, 0, 'R');
            $this->Cell(15, 10, '26', 1, 0, 'R');
            $this->Cell(15, 10, '27', 1, 0, 'R');
            $this->Cell(15, 10, '28', 1, 0, 'R');
            $this->Cell(15, 10, '29', 1, 0, 'R');
            $this->Cell(15, 10, '30', 1, 0, 'R');
            $this->Cell(15, 10, '31', 1, 0, 'R');
            $this->Cell(20, 10, 'TOTAL', 1, 0, 'R');

        }
        $this->Ln(10);

    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();

$emp_id = clean_data($_SESSION["VALID_USER_ID"]);

$rep_id = clean_data($_GET['rep_id']);

$from_date =clean_data($_GET['from_date']);
$change_from_date = strtotime($from_date);
$new_from_date = date('Y-m-d', $change_from_date);

$to_date = clean_data($_GET['to_date']);
$change_to_date = strtotime($to_date);
$new_to_date = date('Y-m-d', $change_to_date);

$comp_id = clean_data($_GET['comp_id']);
$status = clean_data($_GET['status']);

$acct_id = clean_data($_GET['acct_id']);

$period = clean_data($_GET['period']);

$f_grp_1 = clean_data($_GET['f_grp_1']);
$f_grp_2 = clean_data($_GET['f_grp_2']);

//$period='Monthly';
if($period=='Monthly') {
    $pdf->AddPage("L", "Legal");
}else{
    $pdf->AddPage("L", array(200, 600));
}

#    $comp_id ='01';

switch ($f_grp_1)
{
    case 'v.acct_id':
        $f_grp_1_name="n.acct_name";
        break;

    case 'c.comp_id':
        $f_grp_1_name="c.comp_name";
        break;

    case 'year(v.voucher_date)':
        $f_grp_1_name="year(v.voucher_date)";
        break;

    case 's.comp_name':
        $f_grp_1_name="s.comp_name";
        break;

    case 'substr(v.acct_id,1,2)':
        $f_grp_1_name="n1.acct_name";
        break;

    case 'substr(v.acct_id,1,6)':
        $f_grp_1_name="n2.acct_name";
        break;

}


switch ($f_grp_2)
{
    case 'v.acct_id':
        $f_grp_2_name="n.acct_name";
        break;

    case 'c.comp_id':
        $f_grp_2_name="c.comp_name";
        break;

    case 'year(v.voucher_date)':
        $f_grp_2_name="year(v.voucher_date)";
        break;

    case 's.comp_name':
        $f_grp_2_name="s.comp_name";
        break;

    case 'substr(v.acct_id,1,2)':
        $f_grp_2_name="n1.acct_name";
        break;

    case 'substr(v.acct_id,1,2)':
        $f_grp_2_name="n1.acct_name";
        break;

    case 'substr(v.acct_id,1,6)':
        $f_grp_2_name="n2.acct_name";
        break;

}


$and = '';
if($comp_id != "All")
    $and .= " and c.comp_id = '$comp_id'";

if($acct_id != "All")
    $and .= " and v.acct_id like '$acct_id%'";

$f="(v.debit-v.credit)";

try {
    $sql = "SELECT distinct $f_grp_1 grp_1, ($f_grp_1_name) grp_1_name
                    FROM v_vouchers v
                    LEFT JOIN v_nom n ON (v.acct_id = n.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=2) n1 ON (substr(v.acct_id,1,2) = n1.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=6) n2 ON (substr(v.acct_id,1,6) = n2.acct_id)
                    LEFT JOIN company c ON (v.comp_id = c.comp_id)
                    WHERE v.voucher_date BETWEEN '$new_from_date'   AND '$new_to_date'
                    $and
                    Order by 2   
                           ";
//echo $sql;

    $v_result = $dbcon->prepare($sql);
    $v_result->execute();
}
catch(PDOException $e)
{
    echo "Error : ". $e->getMessage();
}


        $grp_1='';

        $u_01_g_tot=0;
        $u_02_g_tot=0;
        $u_03_g_tot=0;
        $u_04_g_tot=0;
        $u_05_g_tot=0;
        $u_06_g_tot=0;
        $u_07_g_tot=0;
        $u_08_g_tot=0;
        $u_09_g_tot=0;
        $u_10_g_tot=0;
        $u_11_g_tot=0;
        $u_12_g_tot=0;
        $u_g_tot=0;

        while ($row_v = $v_result->fetch(PDO::FETCH_ASSOC))
        {
            $grp_1=$row_v['grp_1'];

            if($period=='Monthly'){

                $sql = "SELECT 
                      $f_grp_2 grp_2, 
                      upper($f_grp_2_name) grp_2_name,        
        
                      sum(if (month(v.voucher_date)=1,$f,0)) as u_01, 
                      sum( if (month(v.voucher_date)=2,$f,0) ) as u_02, 
                      sum(if (month(v.voucher_date)=3,$f,0)) as u_03, 
                      sum(if (month(v.voucher_date)=4,$f,0)) as u_04, 
                      sum(if (month(v.voucher_date)=5,$f,0)) as u_05, 
                      sum(if (month(v.voucher_date)=6,$f,0)) as u_06, 
                      sum(if (month(v.voucher_date)=7,$f,0)) as u_07, 
                      sum(if (month(v.voucher_date)=8,$f,0)) as u_08, 
                      sum(if (month(v.voucher_date)=9,$f,0)) as u_09, 
                      sum(if (month(v.voucher_date)=10,$f,0)) as u_10, 
                      sum(if (month(v.voucher_date)=11,$f,0)) as u_11, 
                      sum(if (month(v.voucher_date)=12,$f,0)) as u_12, 
                      sum($f) u
                    FROM v_vouchers v
                    LEFT JOIN v_nom n ON (v.acct_id = n.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=2) n1 ON (substr(v.acct_id,1,2) = n1.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=6) n2 ON (substr(v.acct_id,1,6) = n2.acct_id)
                    LEFT JOIN company c ON (v.comp_id = c.comp_id)
   WHERE v.voucher_date BETWEEN '$new_from_date'   AND '$new_to_date'
   $and
   and $f_grp_1='$grp_1'
   GROUP BY $f_grp_2, $f_grp_2_name 
   HAVING sum($f)<>0
   ORDER BY sum($f) desc
   ";

            }else{

                $sql = "SELECT 
                      $f_grp_2 grp_2, 
                      upper($f_grp_2_name) grp_2_name,        
        
                      sum(if (day(v.voucher_date)=1,$f,0)) as u_01, 
                      sum(if (day(v.voucher_date)=2,$f,0) ) as u_02, 
                      sum(if (day(v.voucher_date)=3,$f,0)) as u_03, 
                      sum(if (day(v.voucher_date)=4,$f,0)) as u_04, 
                      sum(if (day(v.voucher_date)=5,$f,0)) as u_05, 
                      sum(if (day(v.voucher_date)=6,$f,0)) as u_06, 
                      sum(if (day(v.voucher_date)=7,$f,0)) as u_07, 
                      sum(if (day(v.voucher_date)=8,$f,0)) as u_08, 
                      sum(if (day(v.voucher_date)=9,$f,0)) as u_09, 
                      sum(if (day(v.voucher_date)=10,$f,0)) as u_10, 
                      sum(if (day(v.voucher_date)=11,$f,0)) as u_11, 
                      sum(if (day(v.voucher_date)=12,$f,0)) as u_12, 
                      sum(if (day(v.voucher_date)=13,$f,0)) as u_13, 
                      sum(if (day(v.voucher_date)=14,$f,0)) as u_14, 
                      sum(if (day(v.voucher_date)=15,$f,0)) as u_15, 
                      sum(if (day(v.voucher_date)=16,$f,0)) as u_16, 
                      sum(if (day(v.voucher_date)=17,$f,0)) as u_17, 
                      sum(if (day(v.voucher_date)=18,$f,0)) as u_18, 
                      sum(if (day(v.voucher_date)=19,$f,0)) as u_19, 
                      sum(if (day(v.voucher_date)=20,$f,0)) as u_20, 
                      sum(if (day(v.voucher_date)=21,$f,0)) as u_21, 
                      sum(if (day(v.voucher_date)=22,$f,0)) as u_22, 
                      sum(if (day(v.voucher_date)=23,$f,0)) as u_23, 
                      sum(if (day(v.voucher_date)=24,$f,0)) as u_24, 
                      sum(if (day(v.voucher_date)=25,$f,0)) as u_25, 
                      sum(if (day(v.voucher_date)=26,$f,0)) as u_26, 
                      sum(if (day(v.voucher_date)=27,$f,0)) as u_27, 
                      sum(if (day(v.voucher_date)=28,$f,0)) as u_28, 
                      sum(if (day(v.voucher_date)=29,$f,0)) as u_29, 
                      sum(if (day(v.voucher_date)=30,$f,0)) as u_30, 
                      sum(if (day(v.voucher_date)=31,$f,0)) as u_31, 
                      sum($f) u
                    FROM v_vouchers v
                    LEFT JOIN v_nom n ON (v.acct_id = n.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=2) n1 ON (substr(v.acct_id,1,2) = n1.acct_id)
                    LEFT JOIN (select acct_id, acct_name from v_nom where length(acct_id)=6) n2 ON (substr(v.acct_id,1,6) = n2.acct_id)
                    LEFT JOIN company c ON (v.comp_id = c.comp_id)
   WHERE v.voucher_date BETWEEN '$new_from_date'   AND '$new_to_date'
   $and
   and $f_grp_1='$grp_1'
   GROUP BY $f_grp_2, $f_grp_2_name 
   HAVING sum($f)<>0
   ORDER BY sum($f) desc
   
   ";
            }

            try {
                $vd_result = $dbcon->prepare($sql);
                $vd_result->execute();
            }
            catch(PDOException $e)
            {
                echo "Error : ". $e->getMessage();
            }


            $cnt=0;
            $u_01_tot=0;
            $u_02_tot=0;
            $u_03_tot=0;
            $u_04_tot=0;
            $u_05_tot=0;
            $u_06_tot=0;
            $u_07_tot=0;
            $u_08_tot=0;
            $u_09_tot=0;
            $u_10_tot=0;
            $u_11_tot=0;
            $u_12_tot=0;
            $u_13_tot=0;
            $u_14_tot=0;
            $u_15_tot=0;
            $u_16_tot=0;
            $u_17_tot=0;
            $u_18_tot=0;
            $u_19_tot=0;
            $u_20_tot=0;
            $u_21_tot=0;
            $u_22_tot=0;
            $u_23_tot=0;
            $u_24_tot=0;
            $u_25_tot=0;
            $u_26_tot=0;
            $u_27_tot=0;
            $u_28_tot=0;
            $u_29_tot=0;
            $u_30_tot=0;
            $u_31_tot=0;
            $u_tot=0;

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Ln(8);

        $pdf->Cell(20, 8, $row_v['grp_1_name'], 0, 0, 'l');

        $pdf->SetFont('Arial', '', 8);

        while ($row_vd = $vd_result->fetch(PDO::FETCH_ASSOC))
        {

        $cnt +=1;
        $u_tot +=$row_vd['u'];

        $grp_2 = $row_vd['grp_2'];

        $acct_name = $row_vd['grp_2_name'];

        $_SESSION['acct_name'] = $acct_name;

        $pdf->Ln(8);

        $pdf->Cell(80, 8, substr($row_vd['grp_2_name'],0,50), 1, 0, 'l');

        if($period=='Monthly') {
            $u_01_tot +=$row_vd['u_01'];
            $u_02_tot +=$row_vd['u_02'];
            $u_03_tot +=$row_vd['u_03'];
            $u_04_tot +=$row_vd['u_04'];
            $u_05_tot +=$row_vd['u_05'];
            $u_06_tot +=$row_vd['u_06'];
            $u_07_tot +=$row_vd['u_07'];
            $u_08_tot +=$row_vd['u_08'];
            $u_09_tot +=$row_vd['u_09'];
            $u_10_tot +=$row_vd['u_10'];
            $u_11_tot +=$row_vd['u_11'];
            $u_12_tot +=$row_vd['u_12'];

            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_01']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_02']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_03']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_04']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_05']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_06']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_07']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_08']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_09']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_10']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_11']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u_12']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u']), 0), 1, 0, 'R');

        }else{
            $u_01_tot +=$row_vd['u_01'];
            $u_02_tot +=$row_vd['u_02'];
            $u_03_tot +=$row_vd['u_03'];
            $u_04_tot +=$row_vd['u_04'];
            $u_05_tot +=$row_vd['u_05'];
            $u_06_tot +=$row_vd['u_06'];
            $u_07_tot +=$row_vd['u_07'];
            $u_08_tot +=$row_vd['u_08'];
            $u_09_tot +=$row_vd['u_09'];
            $u_10_tot +=$row_vd['u_10'];
            $u_11_tot +=$row_vd['u_11'];
            $u_12_tot +=$row_vd['u_12'];
            $u_13_tot +=$row_vd['u_13'];
            $u_14_tot +=$row_vd['u_14'];
            $u_15_tot +=$row_vd['u_15'];
            $u_16_tot +=$row_vd['u_16'];
            $u_17_tot +=$row_vd['u_17'];
            $u_18_tot +=$row_vd['u_18'];
            $u_19_tot +=$row_vd['u_19'];
            $u_20_tot +=$row_vd['u_20'];
            $u_21_tot +=$row_vd['u_21'];
            $u_22_tot +=$row_vd['u_22'];
            $u_23_tot +=$row_vd['u_23'];
            $u_24_tot +=$row_vd['u_24'];
            $u_25_tot +=$row_vd['u_25'];
            $u_26_tot +=$row_vd['u_26'];
            $u_27_tot +=$row_vd['u_27'];
            $u_28_tot +=$row_vd['u_28'];
            $u_29_tot +=$row_vd['u_29'];
            $u_30_tot +=$row_vd['u_30'];
            $u_31_tot +=$row_vd['u_31'];

            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_01']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_02']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_03']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_04']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_05']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_06']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_07']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_08']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_09']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_10']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_11']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_12']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_13']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_14']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_15']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_16']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_17']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_18']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_19']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_20']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_21']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_22']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_23']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_24']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_25']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_26']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_27']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_28']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_29']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_30']), 0), 1, 0, 'R');
            $pdf->Cell(15, 8, format_number_pdf(($row_vd['u_31']), 0), 1, 0, 'R');
            $pdf->Cell(20, 8, format_number_pdf(($row_vd['u']), 0), 1, 0, 'R');
                                }

        }

        if($u_tot<>0) {
            $pdf->Ln(8);

            $pdf->SetFont('Arial', 'B', 8);

            $pdf->Cell(80, 8, 'Total : ', 0, 0, 'R');

            $u_g_tot += $u_tot;

            if($period=='Monthly') {
                $pdf->Cell(20, 8, format_number_pdf($u_01_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_02_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_03_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_04_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_05_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_06_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_07_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_08_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_09_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_10_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_11_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_12_tot, 0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($u_tot, 0), 1, 0, 'R');

                $u_01_g_tot += $u_01_tot;
                $u_02_g_tot += $u_02_tot;
                $u_03_g_tot += $u_03_tot;
                $u_04_g_tot += $u_04_tot;
                $u_05_g_tot += $u_05_tot;
                $u_06_g_tot += $u_06_tot;
                $u_07_g_tot += $u_07_tot;
                $u_08_g_tot += $u_08_tot;
                $u_09_g_tot += $u_09_tot;
                $u_10_g_tot += $u_10_tot;
                $u_11_g_tot += $u_11_tot;
                $u_12_g_tot += $u_12_tot;

            }else{

                $pdf->Cell(15, 8, format_number_pdf($u_01_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_02_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_03_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_04_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_05_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_06_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_07_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_08_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_09_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_10_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_11_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_12_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_13_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_14_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_15_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_16_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_17_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_18_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_19_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_20_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_21_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_22_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_23_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_24_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_25_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_26_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_27_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_28_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_29_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_30_tot, 0), 1, 0, 'R');
                $pdf->Cell(15, 8, format_number_pdf($u_31_tot, 0), 1, 0, 'R');

                $pdf->Cell(20, 8, format_number_pdf($u_tot, 0), 1, 0, 'R');

                $u_01_g_tot += $u_01_tot;
                $u_02_g_tot += $u_02_tot;
                $u_03_g_tot += $u_03_tot;
                $u_04_g_tot += $u_04_tot;
                $u_05_g_tot += $u_05_tot;
                $u_06_g_tot += $u_06_tot;
                $u_07_g_tot += $u_07_tot;
                $u_08_g_tot += $u_08_tot;
                $u_09_g_tot += $u_09_tot;
                $u_10_g_tot += $u_10_tot;
                $u_11_g_tot += $u_11_tot;
                $u_12_g_tot += $u_12_tot;
                $u_13_g_tot += $u_13_tot;
                $u_14_g_tot += $u_14_tot;
                $u_15_g_tot += $u_15_tot;
                $u_16_g_tot += $u_16_tot;
                $u_17_g_tot += $u_17_tot;
                $u_18_g_tot += $u_18_tot;
                $u_19_g_tot += $u_19_tot;
                $u_20_g_tot += $u_20_tot;
                $u_21_g_tot += $u_21_tot;
                $u_22_g_tot += $u_22_tot;
                $u_23_g_tot += $u_23_tot;
                $u_24_g_tot += $u_24_tot;
                $u_25_g_tot += $u_25_tot;
                $u_26_g_tot += $u_26_tot;
                $u_27_g_tot += $u_27_tot;
                $u_28_g_tot += $u_28_tot;
                $u_29_g_tot += $u_29_tot;
                $u_30_g_tot += $u_30_tot;
                $u_31_g_tot += $u_31_tot;

            }
        }
   }
    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'B', 8);

    $pdf->Cell(80, 8, 'Grand Total : ', 0, 0, 'R');

if($period=='Monthly') {
    $pdf->Cell(20, 8, format_number_pdf($u_01_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_02_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_03_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_04_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_05_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_06_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_07_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_08_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_09_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_10_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_11_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_12_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_g_tot, 0), 1, 0, 'R');
}else {

    $pdf->Cell(15, 8, format_number_pdf($u_01_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_02_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_03_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_04_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_05_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_06_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_07_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_08_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_09_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_10_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_11_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_12_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_13_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_14_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_15_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_16_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_17_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_18_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_19_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_20_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_21_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_22_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_23_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_24_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_25_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_26_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_27_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_28_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_29_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_30_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(15, 8, format_number_pdf($u_31_g_tot, 0), 1, 0, 'R');
    $pdf->Cell(20, 8, format_number_pdf($u_g_tot, 0), 1, 0, 'R');

}
   $pdf->Output();