<?php
session_start();
ob_start();
include("include/dbconnect.php");
include("include/functions.php");
require_once ("fpdf/fpdf.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}


class PDF extends FPDF
{
    /************START PAGE HEADER*********/
    function Header()
    {
        include("include/dbconnect.php");

        $rep_id = clean_data($_GET['rep_id']);
        $rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

        $comp_id = $_GET['comp_id'];

        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");
        }


        $run_time =date('l, F jS, Y H:i:s A');

        $this->SetFont('Arial', 'B', 18);
        $this->Cell(278, 10, strtoupper($comp_name), 0, 0, 'C');
        $this->Ln(10);
        $this->SetFont('Arial', 'U', 18);
        $this->Cell(278, 10, $rep_name, 0, 0, 'C');
        $this->Ln(10);
        $this->Ln(10);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(28);
        $this->Cell(48, 10, 'Report Run on : '. $run_time, 0, 0, 'R');
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(206, 10, 'For the Period : ' . ($from_date) .' To ' . ($to_date), 0, 0, 'R');
#line        $this->Line(11,37,287,37);
        $this->Ln(10);

        $this->Image('images/TableHeader.jpg',10,47,281);
        $this->Ln(10);




    }

// Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF();

$pdf->AliasNbPages();
$pdf->AddPage("L");



        $comp_id = $_GET['comp_id'];
        $emp_id = clean_data($_SESSION["VALID_USER_ID"]);

        
        $from_date = clean_data($_GET['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_GET['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $acct_id = clean_data($_GET['acct_id']);
        $cat_id = clean_data($_GET['cat_id']);
        $loc_id = clean_data($_GET['loc_id']);

        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        }
        else
        {
            $comp_name = find_value('v_system', 'comp_name', "");

        }
        /*************END FINDE COMPANY NAME*****************/

        $and = "";
        $and_comp = "";

        if ($comp_id != "All") {
            $and_comp .= " and v.comp_id = '$comp_id'";
        }
        else
        {
            $and_comp .= " and v.comp_id in(SELECT c.comp_id FROM company c
				LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
				WHERE uc.emp_id = '$emp_id' )";
        }

        if ($acct_id != "All") {
            $and .= " and v.stock_code = '$acct_id'";
        }

        if ($cat_id != "All") {
            $and .= " and i.cat_id = '$cat_id'";
        }


        $and .= " and (v.db_qty is not null or v.cr_qty is not null)";


//        if ($loc_id != "All") {
//            $and .= " and v.loc_id = '$loc_id'";
//        }


        /*****************START GRAND TOTAL VARIABLES**************/
        $g_tot_dbqty = 0;
        $g_tot_crqty = 0;
        $g_bal = 0;
        $g_acct_id = '';
        /*****************END GRAND TOTAL VARIABLES**************/

        //group query date
        $g_voucher_Date = '';


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/
/***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/
try {
    $msqlquery = "SELECT DISTINCT v.stock_code acct_id, v. stock_name acct_name
FROM
	v_stk v
	WHERE 1=1  $and $and_comp";

  // echo $msqlquery;

            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        }
        catch(PDOException $e)
        {
            echo "Error : ". $e->getMessage();
        }


                    $g_o_qty_tot = 0;
                    $g_o_amt_tot = 0;

                    $g_db_qty_tot = 0;
                    $g_db_amt_tot = 0;

                    $g_cr_qty_tot = 0;
                    $g_cr_amt_tot = 0;

                    $g_bal_qty_tot = 0;
                    $g_bal_amt_tot = 0;

        while($mrow = $q_result->fetch(PDO::FETCH_ASSOC)) {
            $g_acct_id = $mrow['acct_id'];
            $g_acct_name = $mrow['acct_name'];

            $bal_qty = 0;
            $bal_amt = 0;

            /***************END MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/


            /***************START MYSQL QUERY FOR GROUP OPENING BALANCE*****************/

            try {
                $ob_query = "SELECT
	sum(v.db_qty - v.cr_qty ) o_bal,
	sum(v.db_amt - v.cr_amt ) o_amt
	FROM
	v_stk v
	WHERE 1=1
	and v.stock_code = '$g_acct_id' and v.voucher_date < '$new_from_date' $and_comp ";

   // echo $ob_query;

                $ob_result = $dbcon->prepare($ob_query);
                $ob_result->execute();
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }
            $ob_row = $ob_result->fetch(PDO::FETCH_ASSOC);

            $bal_qty = $ob_row['o_bal'];
            $bal_amt = $ob_row['o_amt'];


            $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

            try {
                $d_query = "SELECT concat(v.comp_id,'-',v.year_id,'-',v.voucher_id) v_id, v.comp_id, v.voucher_id,v.voucher_date, v.db_qty, v.cr_qty, v.db_amt, v.cr_amt, v.party_name particulars
		FROM v_stk v
		WHERE 1=1
		 AND v.stock_code = '$g_acct_id'  $and $and_comp
		 order by v.voucher_date, v.voucher_order, v.voucher_id, v.lineitem/1";

//echo $d_query;
                $d_result = $dbcon->prepare($d_query);
                $d_result->execute();
            } catch (PDOException $e) {
                echo "Error : " . $e->getMessage();
            }

            // echo $d_query;


            $no_row = $d_result->rowCount();


            if ($bal_qty != 0 or $no_row != 0) {

$pdf->SetFont('Arial', 'B', 12);
$pdf->Ln(10);

$pdf->Cell(1);
$pdf->Cell(120, 8, $g_acct_name, 0, 0, 'l');
$pdf->Cell(80, 8, '', 0, 0, '');
$pdf->Cell(20, 8, 'Opening:', 0, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_qty,0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt/$bal_qty,2), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt,0), 1, 0, 'R');

$pdf->SetFont('Arial', '', 8);


                    $serno = 0;
                    $o_qty_tot = 0;
                    $o_amt_tot = 0;

                    $db_qty_tot = 0;
                    $db_amt_tot = 0;

                    $cr_qty_tot = 0;
                    $cr_amt_tot = 0;

                    $bal_qty_tot = 0;
                    $bal_amt_tot = 0;

                    while ($report_row = $d_result->fetch(PDO::FETCH_ASSOC)) {

                        $serno = $serno + 1;

                        $db_amt_tot += $report_row['db_amt'];
                        $cr_amt_tot += $report_row['cr_amt'];

                        $db_qty_tot += $report_row['db_qty'];
                        $cr_qty_tot += $report_row['cr_qty'];

                        $bal_qty += $report_row['db_qty'] - $report_row['cr_qty'];
                        $bal_amt += $report_row['db_amt'] - $report_row['cr_amt'];

                        $o_rate='';
                        if ($report_row['o_qty']<>0)
                            $o_rate=$report_row['o_amt']/$report_row['o_qty'];

                        $db_rate='';
                        if ($report_row['db_qty']<>0)
                            $db_rate=$report_row['db_amt']/$report_row['db_qty'];

                        $cr_rate='';
                        if ($report_row['cr_qty']<>0)
                            $cr_rate=$report_row['cr_amt']/$report_row['cr_qty'];

                        $bal_rate='';
                        if ($report_row['bal_qty']<>0)
                            $bal_rate=$report_row['bal_amt']/$report_row['bal_qty'];

$pdf->Ln(8);

$pdf->Cell(1);
$pdf->Cell(10, 8, $serno, 1, 0, 'l');
$pdf->Cell(15, 8, format_date($report_row['voucher_date']), 1, 0, 'l');
$pdf->Cell(25, 8, $report_row['v_id'], 1, 0, 'C');
$pdf->Cell(50, 8, $report_row['particulars'], 1, 0, 'L');
$pdf->Cell(20, 8, format_number_pdf($report_row['db_qty'],0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($db_rate,0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($report_row['db_amt'],0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($report_row['cr_qty'],0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($cr_rate,0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($report_row['cr_amt'],0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_qty,0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_rate,0), 1, 0, 'R');
$pdf->Cell(20, 8, format_number_pdf($bal_amt,0), 1, 0, 'R');

                    }

                $db_rate=$db_amt_tot/$db_qty_tot;
                $cr_rate=$cr_amt_tot/$cr_qty_tot;

                $pdf->SetFont('Arial', 'B', 8);

                $pdf->Ln(8);

                $pdf->Cell(1);
                $pdf->Cell(10, 8, '', 1, 0, 'l');
                $pdf->Cell(15, 8, '', 1, 0, 'l');
                $pdf->Cell(25, 8, '', 1, 0, 'C');
                $pdf->Cell(50, 8, 'Total', 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($db_qty_tot,0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($db_rate,0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($db_amt_tot,0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($cr_qty_tot,0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($cr_rate,0), 1, 0, 'R');
                $pdf->Cell(20, 8, format_number_pdf($cr_amt_tot,0), 1, 0, 'R');
                $pdf->Cell(20, 8, '', 1, 0, 'R');
                $pdf->Cell(20, 8, '', 1, 0, 'R');
                $pdf->Cell(20, 8, '', 1, 0, 'R');

                $pdf->SetFont('Arial', '', 8);

                    $g_o_qty_tot += $o_qty_tot;
                    $g_o_amt_tot += $o_amt_tot;

                    $g_db_qty_tot += $db_qty_tot;
                    $g_db_amt_tot += $db_amt_tot;

                    $g_cr_qty_tot += $cr_qty_tot;
                    $g_cr_amt_tot += $cr_amt_tot;

                    $g_bal_qty_tot += $bal_qty_tot;
                    $g_bal_amt_tot += $bal_amt_tot;


            }
        }

$pdf->Output();