<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}



?>


<?php include('header.php'); ?>

<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="reports">
                    Stock</a>
            </li>
            <li class="breadcrumb-item active">Current Stock Qty</li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Current Stock Qty</h4>
                        </div>
                        <div class="card-body">


                            <div class="box ">
                                <div class="col-md-12 col-12">
                                    <div class="box box-slided-up">
                                        <div class="box-header bg-transparent rounded">
                                            <div class="form-row">
                                                <div class="form-group col-md-3">
                                                    <label >Date to</label>
                                                    <input id="todate" type="text" name="todate" class="form-control" value="<?php echo date('d-m-Y'); ?>">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label>Company</label>
                                                    <select class="form-control acct_id" name="comp_id" id="comp_id">
                                                        <option value="All">All</option>
                                                        <?php
                                                        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                        $comp_id = clean_data($_SESSION["comp_id"]);

                                                        try {
                                                            $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' ORDER BY c.comp_id";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label>Category</label>
                                                    <select class="form-control" name="cat_id" id="cat_id"">

                                                        <option value=" All">All</option>

                                                        <?php
                                                        try {
                                                            $cat_query = "SELECT ct.cat_id, ct.cat_name FROM prod_cat ct
					                                         ORDER BY ct.cat_id ASC ";

                                                            $cat_result = $dbcon->prepare($cat_query);
                                                            $cat_result->execute(array());
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        ?>

                                                        <?php
                                                        while ($cat_row = $cat_result->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $cat_row->cat_id . '">' . $cat_row->cat_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>




                                            </div>
                                        </div>





                                        <p>

                                            <button type="button" class="btn btn-light btn-lg ml-1" id="runreport" style="width: 205px; margin-top: 10px;">Run Report</button>
                                            <input type="hidden" name="file_name" id="file_name" value="<?php echo $file_name ?>" class="btn btn-success">
                                            <input type="hidden" name="rep_id" id="rep_id" value="<?php echo $rep_id ?>" class="btn btn-success">

                                        </p>

                                    </div>
                                </div>



                            </div>
                        </div>
                    </div>
                </div>





            </div>


            <div id="view"></div>





    </section>

</div>
















<?php include('footer.php'); ?>

 <!----------------------------START JAVA SCRIPT---------------------------->
 <script type="text/javascript">
        $(document).ready(function() {

            $('#fromdate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,

            });

            $('#todate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
            });


            $('#runreport').click(function()
            {

                var to_date = $('#todate').val();
                var comp_id =  $('#comp_id').val();
                var cat_id =  $('#cat_id').val();
                var mol =  $('#mol').val();



                var datastring = 'to_date=' + to_date + '&comp_id=' + comp_id + '&cat_id=' + cat_id + '&mol=' + mol   +   '&action=search';

                $.ajax({
                    type:"POST",
                    url:"rpt_current_stock_process.php",
                    data:datastring,
                    beforeSend: function()
                    {
                        $("#view").html('<br clear="all"><br clear="all"><div align="left"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> <img src="dist/img/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                    },
                    success: function(result)
                    {
                        //alert(result)



                        $('#view').html(result);

                    }



                });






            });


        });



        //$("#comp_id").select2();
    </script>

    <!----------------------------END JAVA SCRIPT---------------------------->


