<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}

$report = $_GET['report'];


if ($report == 'SL') {
    $b_title = 'Sale';
    $title = 'Sale Day Book';
}

if ($report == 'DC') {
    $title = 'DC Day Book';
}

if ($report == 'PL') {
    $b_title = 'Purchase';
    $title = 'Purchase Day Book';
}


if ($report == 'ST') {
    $title = 'Stock Transfer Day Book';
}

if ($report == 'RT') {
    $title = 'Sale Return Day Book';
}

if ($report == 'SD') {
    $title = 'Sale Discount Day Book';
}

if ($report == 'SR') {
    $title = 'Recovery Daybook';
}

if ($report == 'MO') {
    $title = 'Manufacturing Order Daybook';
}


$rep_id = clean_data($_GET['rep_id']);
$rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");

?>


<?php include('header.php'); ?>
<title><?php echo $title;?> | <?php echo $row->acct_name; ?></title>
<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="reports">
                    <?php echo $b_title;?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo $title;?></li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo $title;?></h4>
                        </div>
                        <div class="card-body">


                            <div class="box ">
                                <div class="col-md-12 col-12">
                                    <div class="box box-slided-up">
                                        <div class="box-header bg-transparent rounded">
                                            <div class="form-row">

                                                <div class="form-group col-md-3">
                                                    <label>Date From</label>
                                                    <input id="fromdate" type="text" name="fromdate" class="form-control" value="<?php echo date('d-m-Y'); ?>">

                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label>Date to</label>
                                                    <input id="todate" type="text" name="todate" class="form-control" value="<?php echo date('d-m-Y'); ?>">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label>Company</label>
                                                    <select class="form-control acct_id" name="comp_id" id="comp_id">
                                                        <option value="All">All</option>
                                                        <?php
                                                        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                        $comp_id = clean_data($_SESSION["comp_id"]);

                                                        try {
                                                            $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' ORDER BY c.comp_id";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <br>

                                                    <button class="btn btn-light btn-lg font-15 mt-1 w-75 btn-lg" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                                        Advance
                                                    </button>
                                                </div>
                                            </div>





                                            <div class="collapse" id="collapseExample">
                                                <div class="form-row">

                                                    <div class="form-group col-md-3">
                                                        <label>Voucher Id</label>
                                                        <input id="voucher_id" type="text" name="fromvoucher_iddate" class="form-control">
                                                    </div>

                                                    <div class="form-group col-md-3">
                                                        <label>Stock Name</label>
                                                        <select style="width:100%" name="stock_code" id="stock_code" class="acct_id">

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT i.stock_code, concat(i.description,'-',i.stock_code) description FROM v_item i ORDER BY i.stock_code ASC";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                if ($stock_code == $rowd->stock_code && $ledger == 'N') {
                                                                    echo '<option  value="' . $rowd->stock_code . '"selected>' . $rowd->description . '</option>';
                                                                } else {
                                                                    echo '<option  value="' . $rowd->stock_code . '">' . $rowd->description . '</option>';
                                                                }
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-md-3">
                                                        <label>Brand</label>
                                                        <select style="width:100%" name="type_id" id="type_id" class="acct_id">

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT c.type_id acct_id, c.type_name acct_name FROM prod_type c ORDER BY 2 ASC";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                echo '<option  value="' . $rowd->acct_id . '">' . $rowd->acct_name . '</option>';
                                                            }

                                                            ?>
                                                        </select>
                                                    </div>


                                                    <div class="form-group col-md-3">
                                                        <label>Category</label>
                                                        <select style="width:100%" name="cat_id" id="cat_id" class="acct_id">

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT c.cat_id, c.cat_name FROM prod_cat c ORDER BY c.cat_id ASC";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                echo '<option  value="' . $rowd->cat_id . '">' . $rowd->cat_name . '</option>';
                                                            }

                                                            ?>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-md-3">
                                                        <label>Report Type</label>
                                                        <select style="width: 100%;" name="rpt_type" id="rpt_type" class="acct_id">

                                                            <option value="RT">Sale Return</option>
                                                            <?php
                                                            $selected = '';
                                                            if ($report == 'SL') {
                                                            ?>
                                                                <option selected value="SL">Sale</option>
                                                            <?php } ?>

                                                            <?php
                                                            $selected = '';
                                                            if ($report == 'DC') {
                                                            ?>
                                                                <option selected value="DC">Delivery Challan</option>
                                                            <?php } ?>

                                                            <?php
                                                            if ($report == 'PL') {
                                                            ?>
                                                                <option value="PL" selected>Purchase</option>
                                                            <?php } ?>
                                                            <?php
                                                            if ($report == 'ST') {
                                                                $selected = 'selected';
                                                            ?>

                                                                <option selected value="ST">Stock</option>

                                                            <?php } ?>

                                                            <?php
                                                            if ($report == 'RT') {
                                                            ?>
                                                                <option value="RT">Sale Return</option>
                                                            <?php } ?>

                                                            <?php
                                                            if ($report == 'SD') {
                                                            ?>
                                                                <option value="ST">Sale Discount</option>
                                                            <?php } ?>

                                                            <?php
                                                            if ($report == 'SR') {
                                                            ?>
                                                                <option value="SR">Sale Recovery</option>
                                                            <?php } ?>

                                                           <!-- <option value="All">All</option>
                                                            <option selected value="SL">Sale</option>
                                                            <option value="DC">Delivery Challan</option>
                                                            <option value="SD">Invoice Discount</option>
                                                            <option value="RT">Sale Return</option>
                                                            <option value="PL" <?php /*echo $selected */?>>Purchase</option>
                                                            <option value="MO">Manufacturing Order</option>
                                                            <option <?php /*echo $selected */?> value="ST">Stock</option>-->
                                                        </select>
                                                    </div>


                                                    <div class="form-group col-md-3">
                                                        <label>Filter Type</label>
                                                        <select style="width:100%" name="filter_type" id="filter_type" class="acct_id">

                                                            <option value="All">All</option>
                                                            <option value="ZERO_COST">Zero Cost Items</option>
                                                            <option value="DISCOUNT">Discount Items</option>
                                                            <option value="PROFIT">Profit Items</option>
                                                            <option value="LOSS">Loss Items</option>
                                                            <option value="ZERO_PROFIT">Zero Profit Items</option>
                                                        </select>
                                                    </div>





                                                        <div class="form-group col-md-2">
                                                            <label>Location</label>
                                                        <select style="width:100%" name="loc_id"
                                                                id="loc_id"
                                                                class="acct_id" >

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT l.loc_id, l.loc_name FROM location l ORDER BY l.loc_id";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ))
                                                            {

                                                                echo '<option  value="' . $rowd->loc_id . '">' . $rowd->loc_name . '</option>';

                                                            }

                                                            ?>
                                                        </select>
                                                        </div>



                                                    <div class="form-group col-md-3">
                                                        <label>Customers</label>
                                                        <select style="width:100%" name="acct_id"
                                                                id="acct_id"
                                                                class="acct_id" >

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.acct_id, concat(n.acct_id,'-',n.acct_name) acct_name  FROM nom n where (n.acct_id like '261000%' OR n.acct_id like '131000%') and length (n.acct_id) = 10
                                                       ORDER BY 2";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            }
                                                            catch(PDOException $e)
                                                            {
                                                                echo "Error : ". $e->getMessage();
                                                            }

                                                            while($comp_row = $q->fetch(PDO::FETCH_OBJ))
                                                            {
                                                                echo '<option value="'.$comp_row->acct_id.'">'.$comp_row->acct_name.'</option>';
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>


<!--
                                                    <div class="form-group col-md-3">
                                                        <label>Sale Type</label>

                                                        <select class="form-control" name="sale_type" id="sale_type">

                                                            <option value="All">All</option>
                                                            <option value="Credit">Credit</option>
                                                            <option value="Cash">Cash</option>
                                                        </select>
                                                    </div>-->

                                                    <div class="form-group col-md-3">
                                                        <label>Status</label>
                                                        <select name="status" id="status" class=" form-control acct_id" style="width: 100%;">
                                                            <option   value="All">All</option>
                                                            <option   value="Transit">Transit</option>
                                                            <option  value="Arrived" selected >Arrived</option>
                                                        </select>
                                                    </div>








                                                </div>
                                            </div>
















                                            <p>

                                                <button type="button" class="btn btn-light btn-lg font-15 ml-1" id="runreport" style="width: 203px; margin-top: 10px;">Run Report</button>

                                            </p>

                                        </div>
                                    </div>



                                </div>
                            </div>
                        </div>
                    </div>



                    <div id="view"></div>

                </div>











    </section>

</div>
















<?php include('footer.php'); ?>

<!----------------------------START JAVA SCRIPT---------------------------->
<script type="text/javascript">
    $(document).ready(function() {

        $('#fromdate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            orientation: 'bottom'

        });

        $('#todate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            orientation: 'bottom'
        });


        $('#runreport').click(function() {

            var from_date = $('#fromdate').val();
            var to_date = $('#todate').val();
            var comp_id = $('#comp_id').val();
            var rpt_type = $('#rpt_type').val();
            var filter_type = $('#filter_type').val();
            var cat_id = $('#cat_id').val();
            var stock_code = $('#stock_code').val();
            var cat_id = $('#cat_id').val();
            var type_id = $('#type_id').val();
            var loc_id =  $('#loc_id').val();
            var acct_id =  $('#acct_id').val();
            var sale_type =  $('#sale_type').val();
            var status =  $('#status').val();



            var datastring = 'from_date=' + from_date +
                '&to_date=' + to_date +
                '&comp_id=' + comp_id +
                '&rpt_type=' + rpt_type +
                '&filter_type=' + filter_type +
                '&stock_code=' + stock_code +
                '&cat_id=' + cat_id +
                '&type_id=' + type_id +
                '&voucher_id=' + voucher_id +
                '&loc_id=' + loc_id   +
                '&acct_id=' + acct_id   +
                '&sale_type=' + sale_type  +
                '&status=' + status +
                '&action=search';

            $.ajax({
                type: "POST",
                url: "rpt_sale_process.php",
                data: datastring,
                beforeSend: function() {
                    $("#view").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="assets/img/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                },
                success: function(result) {
                    //alert(result)



                    $('#view').html(result);

                }



            });






        });


    });
</script>

<!----------------------------END JAVA SCRIPT---------------------------->