<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}

$rep_id = clean_data($_GET['rep_id']);
$rep_name=find_value('reports','report_name'," and rep_id='$rep_id'");




?>

<?php include('header.php'); ?>
<title><?php echo $rep_name;?> | <?php echo $row->acct_name; ?></title>
<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="reports">
                    Sales</a>
            </li>
            <li class="breadcrumb-item active">Sale Daybook</li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Sale Report</h4>
                        </div>
                        <div class="card-body">


                            <div class="box ">
                                <div class="col-md-12 col-12">
                                    <div class="box box-slided-up">
                                        <div class="box-header bg-transparent rounded">
                                            <div class="form-row">

                                                <div class="form-group col-md-3">
                                                    <label>Date From</label>
                                                    <input id="fromdate" type="text" name="fromdate"  class="form-control" value="<?php echo date('d-m-Y');?>" >                                
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label>Date to</label>
                                                    <input id="todate" type="text" name="todate" class="form-control" value="<?php echo date('d-m-Y'); ?>">
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label>Company</label>
                                                    <select class="form-control acct_id" name="comp_id" id="comp_id">
                                                        <option value="All">All</option>
                                                        <?php
                                                        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                        $comp_id = clean_data($_SESSION["comp_id"]);

                                                        try {
                                                            $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' ORDER BY c.comp_id";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <br>

                                                    <button class="btn btn-light btn-lg font-15 mt-1 w-75 btn-lg" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                                        Advance
                                                    </button>
                                                </div>
                                            </div>





                                            <div class="collapse" id="collapseExample">
                                                
                                            <div class="form-row">
                                                    <div class="form-group col-md-3">
                                                        <label>Department</label>
                                                        <select style="width:100%" name="type_id" id="type_id" class="acct_id">

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT c.type_id acct_id, c.type_name acct_name FROM prod_type c ORDER BY 2 ASC";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                echo '<option  value="' . $rowd->acct_id . '">' . $rowd->acct_name . '</option>';
                                                            }

                                                            ?>
                                                        </select>
                                                    </div>


                                                    <div class="form-group col-md-3">
                                                        <label>Category</label>
                                                        <select style="width:100%" name="cat_id" id="cat_id" class="acct_id">

                                                            <option value="All">All</option>
                                                            <?php

                                                            try {
                                                                $p_query = "SELECT c.cat_id, c.cat_name FROM prod_cat c ORDER BY c.cat_id ASC";
                                                                $p_result = $dbcon->prepare($p_query);
                                                                $p_result->execute(array());
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                                echo '<option  value="' . $rowd->cat_id . '">' . $rowd->cat_name . '</option>';
                                                            }

                                                            ?>
                                                        </select>
                                                    </div>

                                                    <div class="form-group col-md-3">
                                                        <label>Report Type</label>
                                                        <select style="width: 100%;" name="rpt_type"
                                            id="rpt_type"
                                            class="acct_id" >


                                        <?php
                                        $selected='';
                                        if ($report == 'SL')
                                        {
                                            ?>
                                            <option selected value="SL">Sale</option>
                                        <?php } ?>

                                        <?php
                                        $selected='';
                                        if ($report == 'DC')
                                        {
                                            ?>
                                            <option selected value="DC">Delivery Challan</option>
                                        <?php } ?>

                                        <?php
                                        if ($report == 'PL')
                                        {
                                            ?>
                                            <option value="PL" selected>Purchase</option>
                                        <?php } ?>
                                        <?php
                                        if ($report == 'ST')
                                        {
                                            $selected='selected';
                                            ?>

                                            <option selected value="ST">Stock</option>

                                        <?php } ?>

                                        <?php
                                        if ($report == 'RT')
                                        {
                                            ?>
                                            <option value="ST">Sale Return</option>
                                        <?php } ?>

                                        <?php
                                        if ($report == 'SD')
                                        {
                                            ?>
                                            <option value="ST">Sale Discount</option>
                                        <?php } ?>

                                        <?php
                                        if ($report == 'SR')
                                        {
                                            ?>
                                            <option value="SR">Sale Recovery</option>
                                        <?php } ?>

                                        <option value="All">All</option>
                                        <option selected value="SL">Sale</option>
                                        <option value="DC">Delivery Challan</option>
                                        <option value="SD">Invoice Discount</option>
                                        <option value="RT">Sale Return</option>
                                        <option value="PL">Purchase</option>
                                        <option value="MO">Manufacturing Order</option>
                                        <option <?php echo $selected?> value="ST">Stock</option>
                                    </select>
                                                    </div>


                                          





                                                </div>
                                            </div>
















                                            <p>

                                                <button type="button" class="btn btn-light btn-lg font-15 ml-1" id="runreport" style="width: 203px; margin-top: 10px;">Run Report</button>

                                            </p>

                                        </div>
                                    </div>



                                </div>
                            </div>
                        </div>
                    </div>




                    <div id="view"></div>
                </div>








    </section>

</div>
















<?php include('footer.php'); ?>

<!----------------------------START JAVA SCRIPT---------------------------->
<script type="text/javascript">
        $(document).ready(function() {

            $('#fromdate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                orientation: 'bottom'

            });

            $('#todate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                orientation: 'bottom'
            });


            $('#runreport').click(function()
            {

                var from_date = $('#fromdate').val();
                var to_date = $('#todate').val();
                var comp_id =  $('#comp_id').val();
                var cat_id =  $('#cat_id').val();
                var type_id =  $('#type_id').val();
                var rpt_type =  $('#rpt_type').val();



                var datastring = 'from_date=' + from_date + '&to_date=' + to_date + '&type_id=' + type_id + '&cat_id=' + cat_id + '&comp_id=' + comp_id + '&rpt_type=' + rpt_type   +   '&action=search';

                $.ajax({
                    type:"POST",
                    url:"rpt_sales_process.php",
                    data:datastring,
                    beforeSend: function()
                    {
                        $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
                    },
                    success: function(result)
                    {
                        //alert(result)



                        $('#view').html(result);

                    }



                });






            });


        });



    
    </script>

    <!----------------------------END JAVA SCRIPT---------------------------->






