<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if (isset($_POST['action']) && !empty($_POST['action'])) {
    if ($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $rpt_type = clean_data($_POST['rpt_type']);
        $filter_type = clean_data($_POST['filter_type']);
        $voucher_id = clean_data($_POST['voucher_id']);

        $stock_code = clean_data($_POST['stock_code']);

        $type_id = clean_data($_POST['type_id']);
        $cat_id = clean_data($_POST['cat_id']);

        $loc_id = clean_data($_POST['loc_id']);
        $acct_id = clean_data($_POST['acct_id']);
        $sale_type = clean_data($_POST['sale_type']);
        $s_comp_id = clean_data($_SESSION["comp_id"]);
        $status = clean_data($_POST['status']);
        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('v_system', 'rate_decimals', '');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('v_system', 'comp_name', "");
            $comp_detail_one = find_value('company', 'detail_one', " and comp_id = '$s_comp_id'");
        }
        /*************END FINDE COMPANY NAME*****************/


        $and = " and substr(v.voucher_id,1,2) in('SL','PL','ST','DC', 'RT')";
        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {

            $and .= " and v.comp_id = '$comp_id'";
        } else {
            $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
        }


        if ($rpt_type != "All") {
            $and .= " and substring(v.voucher_id,1,2) = '$rpt_type'";
        }

        if ($filter_type == "ZERO_COST") {
            $and .= " and ((v.cost_amt/v.cr_qty)=0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "DISCOUNT") {
            $and .= " and (v.disc_amt<>0)";
        } else if ($filter_type == "PROFIT") {
            $and .= " and ((v.cr_amt-v.cost_amt)>0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "LOSS") {
            $and .= " and ((v.cr_amt-v.cost_amt)<0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL','ST'))";
        } else if ($filter_type == "ZERO_PROFIT") {
            $and .= " and ((v.cr_amt-v.cost_amt)=0)";
            $and .= " and (substring(v.voucher_id,1,2) IN('SL'))";
        }

        if ($cat_id != "All") {
            $and .= " and (i.cat_id = '$cat_id')";
        }

        if ($type_id != "All") {
            $and .= " and (i.type_id = '$type_id')";
        }

        if ($stock_code != "All") {
            $and .= " and (i.stock_code = '$stock_code')";
        }



        if ($loc_id != "All") {
            $and .= " and v.loc_id = '$loc_id'";
        }

        if ($acct_id != "All") {
            $and .= " and v.party_id = '$acct_id'";
        }

        if ($sale_type == "Credit") {

            $and .= " and  n.cash<>'Y'";

        }

        if ($sale_type == "Cash") {

            $and .= "  and n.cash='Y'";

        }


        if ($status != "All") {
            $and .= " and v.pl_status = '$status'";
        }






        /*
        if ($voucher_id != "")
                $and .= " and v.voucher_id = '$voucher_id'";


*/

        $report_name = '';
        if ($rpt_type == "All") {

            $report_name = "Daily Report";
        }

        if ($rpt_type == "SL") {

            $report_name = "Sale Report";
        }

        if ($rpt_type == "DC") {

            $report_name = "Delivery Challan Report";
        }

        if ($rpt_type == "SR") {

            $report_name = "Sale Recovery";
        }

        if ($rpt_type == "RT") {

            $report_name = "Sale Retrun";
        }

        if ($rpt_type == "PL") {

            $report_name = "Purchase Report";
        }


        if ($rpt_type == "ST") {

            $report_name = "Stock Report";
        }





        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/

        if (($rpt_type == "ST")) {
            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
null bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
null cost_price,

null profit,
null disc_amt,
i.unit_name


FROM v_stk v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and order by v.voucher_date, v.voucher_id";
        }

        if (($rpt_type == "RT")) {

            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST', 'RT'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.db_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST', 'RT'),if(ifnull(v.cost_amt,0)=0,0,v.db_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and  
		order by v.voucher_date, v.voucher_id,v.lineitem/1";

        }





        if (($rpt_type == "SL")) {

            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
       v.year_id,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.cr_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cr_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		order by v.voucher_date, v.voucher_id,v.lineitem/1";
        }


        if (($rpt_type == "PL")) {

            $msqlquery = "SELECT

v.comp_id,
concat(
        `v`.`comp_id`,
        `v`.`voucher_id`
    ) AS `voucher_id`,
v.voucher_date,
v.lineitem,
v.party_name,
v.stock_code,
v.stock_name,
v.rate,
v.bill_no,
       v.year_id,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cost_amt/v.cr_qty) ,0) cost_price,

if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cr_amt-v.cost_amt) ,0) profit,
v.disc_amt,
i.unit_name


FROM v_p_vouchers v
LEFT JOIN v_item i on v.stock_code=i.stock_code
	
	
	WHERE
		1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		order by v.voucher_date, v.voucher_id,v.lineitem/1";
        }



        //echo $msqlquery;
        try {
            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }






        ?>


        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d_text_align">
                        <a href="pdf_rpt_sale_item?from_date=<?php echo $new_from_date; ?>&to_date=<?php echo $new_to_date; ?>&comp_id=<?php echo $comp_id; ?>&stock_code=<?php echo $stock_code; ?>&rpt_type=<?php echo $rpt_type; ?>" target="_blank" style="text-decoration:none;"  data-toggle="tooltip" data-placement="top" title="PDF">

                            <i class="fa fa-file-pdf pull-right"></i>
                        </a>
                    </div>
                    <div class="card-body">


                        <div class="box ">
                            <div class="col-md-12 col-12">



                                <h4 style="text-align: center; font-size: 50px; font-weight: bold;"><?php echo $comp_name ; ?></h4>
                                <h5 style="text-align: center; font-size: 16px; font-weight: bold;"><?php echo $comp_detail_one ; ?></h5>
                                <h4 style="text-align: center; font-size: 16px; font-weight: bold;"><?php echo $report_name ; ?></h4>
                                <h3 style="text-align: center; font-size: 16px; font-weight: bold;"><?php echo $from_date.  ' - ' . $to_date ; ?></h3>



                                <table class="table table-bordered table-hover ">
                                    <thead class="sticky-top">
                                    <tr>
                                        <th>Sr</th>
                                        <th>ID</th>

                                        <th>Date</th>

                                        <th>Product Code</th>
                                        <th>Product Name</th>
                                        <th>Unit</th>
                                        <th style="text-align: right;">Qty</th>
                                        <th style="text-align: right;">Rate</th>
                                        <th style="text-align: right;">Disc</th>
                                        <th style="text-align: right;">Amount</th>
                                        <th style="text-align: right;">Cost</th>
                                        <th style="text-align: right;">Profit</th>
                                        <th style="text-align: right;">Profit %</th>

                                    </tr>
                                    </thead>
                                    <?php





                                    $serno = 0;
                                    $g_q_tot = '';
                                    $g_amt = '';
                                    $g_disc_amt = '';
                                    $g_profit = '';

                                    while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                                        $serno = $serno + 1;

                                        $g_q_tot += $report_row['qty'];

                                        $g_disc_amt += $report_row['disc_amt'];
                                        $g_amt += $report_row['amt'];
                                        $g_profit += $report_row['profit'];
                                        $g_cost_tot += $report_row['cost_price'];

                                        if (substr($report_row['voucher_id'], 2, 2) == 'SL') {
                                            $voucherID = substr($report_row['voucher_id'], 4, 6);
                                            $link_voucher = 'sale_invoice_detail';
                                            $p_compId = 'comp_id';
                                            $menu_id='1.1';
                                            $vouchertype = substr($report_row['voucher_id'],2,2);
                                            $v_comp_id = substr( $report_row['voucher_id'],0,2);

                                            $p_year_id = $report_row['year_id'];
                                        }


                                        if (substr($report_row['voucher_id'], 2, 2) == 'PL') {
                                            $voucherID = substr($report_row['voucher_id'], 4, 6);
                                            $link_voucher = 'pl_inv_detail';
                                            $p_compId = 'comp_id';
                                            $menu_id='2.1';
                                            $vouchertype = substr($report_row['voucher_id'],2,2);
                                            $v_comp_id = substr( $report_row['voucher_id'],0,2);

                                            $p_year_id = $report_row['year_id'];
                                        }




                                        $profit_margin = intval($report_row['profit'] * 100 / $report_row['amt']);




                                        ?>

                                        <tr>
                                            <td><?php echo ($serno); ?></td>
                                            <td><a href="<?php echo $link_voucher; ?>?v_id=<?php echo $voucherID; ?>&voucher_type=<?php echo $vouchertype; ?>&posted='on'&comp_id=<?php echo $v_comp_id; ?>&year_id=<?php echo $p_year_id;?>&menu_id=<?php echo $menu_id;?>" target="_blank"><?php echo $report_row['voucher_id']; ?></a></td>

                                            <td><?php echo $report_row['voucher_date']; ?></td>

                                            <td><?php echo ($report_row['stock_code']); ?></td>
                                            <td><?php echo ($report_row['stock_name']); ?></td>
                                            <td><?php echo ($report_row['unit_name']); ?></td>
                                            <td align=right><?php echo format_number($report_row['qty'], 0); ?></td>
                                            <td align=right><?php echo format_number($report_row['rate'], $rate_decimals); ?></td>
                                            <td align=right><?php echo format_number($report_row['disc_amt'], 0); ?></td>
                                            <td align=right><?php echo format_number($report_row['amt'], 0); ?></td>
                                            <td align=right><?php echo format_number($report_row['cost_price'], $rate_decimals); ?></td>
                                            <td align=right><?php echo format_number($report_row['profit'], 0); ?></td>
                                            <td align=right><?php echo format_number($profit_margin, 0); ?></td>

                                        </tr>
                                        <?php

                                    }
                                    ?>
                                    <tr>



                                        <td></td>

                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td align="right"><b>Total</b></td>
                                        <td align=right><b><?php echo format_number($g_q_tot, 0); ?></b></td>

                                        <td></td>
                                        <td align=right><b><?php echo format_number($g_disc_amt, 0); ?></b></td>
                                        <td align=right><b><?php echo format_number($g_amt, 0); ?></b></td>
                                        <td align=right><b><?php echo format_number($g_cost_tot, 0); ?></b></td>
                                        <td align=right><b><?php echo format_number($g_profit, 0); ?></b></td>
                                    </tr>



                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php
    }
}



?>