<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

if (isset($_POST['action']) && !empty($_POST['action'])) {
    if ($_POST['action'] == "search") {

        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);

        $from_date = clean_data($_POST['from_date']);
        $change_from_date = strtotime($from_date);
        $new_from_date = date('Y-m-d', $change_from_date);

        $to_date = clean_data($_POST['to_date']);
        $change_to_date = strtotime($to_date);
        $new_to_date = date('Y-m-d', $change_to_date);

        $comp_id = clean_data($_POST['comp_id']);

        $bill_type = clean_data($_POST['bill_type']);


        /*****************START MYSQL VARIABLES**************/
        $rate_decimals = find_value('v_system', 'rate_decimals', '');

        $comp_name = '';
        /*************START FINDE COMPANY NAME***************/
        if ($comp_id != "All") {

            $comp_name = find_value('company', 'comp_name', " and comp_id = '$comp_id'");
        } else {
            $comp_name = find_value('v_system', 'comp_name', "");
        }
        /*************END FINDE COMPANY NAME*****************/


        $and = " and substr(v.voucher_id,1,2) in('SL','PL','ST','DC')";
        $and .= " and (v.voucher_date BETWEEN '$new_from_date'  AND '$new_to_date')";

        if ($comp_id != "All") {

            $and .= " and v.comp_id = '$comp_id'";
        } else {
            $and .= " and v.comp_id in(SELECT c.comp_id FROM company c
                    LEFT JOIN users_comp uc on c.comp_id=uc.comp_id
                    WHERE uc.emp_id = '$emp_id' )";
        }

        if ($bill_type != "All") {
            $and .= " and (v.bill_type = '$bill_type')";
        }


        /*****************END MYSQL VARIABLES**************/


        /***************START MYSQL QUERY FOR GROUP ACCOUNT ID AND ACCOUNT NAME*****************/


            $msqlquery = "SELECT
       v.bill_type,
       p.acct_name,
       sum(if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)) amt
       FROM v_p_vouchers v
           LEFT JOIN v_party p on v.bill_type = p.acct_id
	        WHERE
		    1 = 1 $and  and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
		    GROUP BY v.bill_type
            order by v.voucher_date, v.voucher_id,v.lineitem/1 ";



        //echo $msqlquery;
        try {
            $q_result = $dbcon->prepare($msqlquery);
            $q_result->execute();
        } catch (PDOException $e) {
            echo "Error : " . $e->getMessage();
        }






        ?>


        <h1 style="text-align: center; font-size: 40px; font-weight: bold;"><?php echo $comp_name; ?></h1>
        <h1 style="text-align: center; font-size: 20px; font-weight: bold;">Daily Sale Status</h1>
        <h1 style="text-align: center; font-size: 12px; font-weight: bold;">Date <?php echo $from_date . ' - '. $to_date;?></h1>

        <a href="pdf_sale_status?from_date=<?php echo $new_from_date; ?>&to_date=<?php echo $new_to_date; ?>&comp_id=<?php echo $comp_id; ?>&bill_type=<?php echo $bill_type; ?>" target="_blank" style="text-decoration:none; color:#FFF" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="PDF">PDF</a>


            <table class="table table-bordered table-striped">
                <tr>
                    <th>Sr</th>
                    <th>Bill Type</th>
                    <th>Amount</th>

                </tr>
                <?php





                $serno = 0;
                $g_q_tot = '';
                $g_amt = '';


                while ($report_row = $q_result->fetch(PDO::FETCH_ASSOC)) {
                    $serno = $serno + 1;

                    $g_amt += $report_row['amt'];



                    ?>

                    <tr>
                        <td><?php echo ($serno); ?></td>
                        <td><?php echo $report_row['acct_name']; ?></td>
                        <td><?php echo $report_row['amt']; ?></td>



                    </tr>
                    <?php

                }
                ?>
                <tr>



                    <td></td>
                    <td ><b>Total</b></td>
                    <td ><b><?php echo format_number( $g_amt , 0); ?></b></td>


                </tr>



            </table>



        <?php
    }
}



?>