<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}

$rep_id = clean_data($_GET['rep_id']);
$rep_name = find_value('reports', 'report_name', " and rep_id='$rep_id'");
$file_name = 'pdf_' . $_GET["file_name"];

$comp_id =  $_SESSION["comp_id"];

?>

<?php include('header.php'); ?>

<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="index">
                    <i data-feather="home"></i></a>
            </li>
            <li class="breadcrumb-item active"><?php echo $rep_name; ?></li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo $rep_name; ?></h4>
                        </div>
                        <div class="card-body">


                            <div class="box ">
                                <div class="col-md-12 col-12">
                                    <div class="box box-slided-up">
                                        <div class="box-header bg-transparent rounded">
                                            <div class="form-row">

                                                <div class="form-group col-md-2">
                                                    <label>Date From</label>
                                                    <input type="text" class="form-control" name="fromdate" id="fromdate" placeholder="Date From" value="<?php echo date('01-m-Y'); ?>">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label>Date to</label>
                                                    <input id="todate" type="text" name="todate" class="form-control" value="<?php echo date('d-m-Y'); ?>">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label>Company</label>
                                                    <select class="form-control acct_id" name="comp_id" id="comp_id">
                                                        <option value="All">All</option>
                                                        <?php
                                                        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                        $comp_id = clean_data($_SESSION["comp_id"]);

                                                        try {
                                                            $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' ORDER BY c.comp_id";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>

                                                <div class="form-group col-md-3">
                                                    <label>Account</label>
                                                    <select class="form-control acct_id" name="party_id" id="party_id" style="width:100%;">

                                                        <option value="All">All</option>
                                                        <?php
                                                        try {
                                                            $comp_sql = "SELECT n.acct_id, n.acct_name FROM v_party n ORDER BY 2";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                        }
                                                        ?>


                                                    </select>
                                                </div>

                                                <div class="form-group col-md-2">
                                                    <br>

                                                    <button class="btn btn-primary mt-1 w-75 btn-lg" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                                        Advance
                                                    </button>
                                                </div>





                                            </div>





                                            <div class="collapse" id="collapseExample">

                                                <div class="form-row">
                                                    <div class="form-group col-md-3">
                                                        <label>Agent</label>
                                                        <select class="form-control acct_id" name="sp_id" id="sp_id" style="width:100%;">

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.acct_id, concat(n.acct_name,'-',n.acct_id) acct_name FROM sp n
                                                                            ORDER BY 2";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>



                                                    <div class="form-group col-md-3">
                                                        <label>Regions</label>
                                                        <select class="form-control acct_id" name="reg_id" id="reg_id" style="width:100%;">

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.reg_id acct_id, concat(n.reg_id, ' ', n.reg_name) acct_name FROM regions n
                                                       ORDER BY 1";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>



                                                    <div class="form-group col-md-3">
                                                        <label>Product</label>
                                                        <select class="form-control acct_id" name="stock_code" id="stock_code" style="width:100% ;">

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.item_code acct_id, concat(n.description,'-',n.item_code) acct_name FROM v_item n
                                                                                ORDER BY 2";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>


                                                    <div class="form-group col-md-3">
                                                        <label>Color</label>
                                                        <select class="form-control acct_id" name="color_id" id="color_id" style="width: 100%">

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.color_id acct_id, n.description acct_name FROM color n
                                                                             ORDER BY 2";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>



                                                    <div class="form-group col-md-3">
                                                        <label>Size</label>
                                                        <select class="form-control acct_id" name="size_id" id="size_id" style="width:100%;">

                                                            <option value="All">All</option>
                                                            <?php
                                                            try {
                                                                $comp_sql = "SELECT n.size_id acct_id, n.size acct_name FROM size n
                                                       ORDER BY 2";
                                                                $q = $dbcon->prepare($comp_sql);
                                                                $q->execute();
                                                            } catch (PDOException $e) {
                                                                echo "Error : " . $e->getMessage();
                                                            }

                                                            while ($comp_row = $q->fetch(PDO::FETCH_OBJ)) {
                                                                echo '<option value="' . $comp_row->acct_id . '">' . $comp_row->acct_name . '</option>';
                                                            }
                                                            ?>


                                                        </select>
                                                    </div>



                                                    <div class="form-group col-md-3">
                                                        <label>>Order By</label>
                                                        <select class="form-control acct_id" name="order_by" id="order_by" style="width:100%;">

                                                            <option value=""></option>
                                                            <option value="Qty">Qty</option>
                                                            <option value="Amount">Amount</option>

                                                            <option></option>
                                                        </select>
                                                    </div>



                                                    <div class="form-group col-md-3">
                                                        <label>Sale Days >=</label>
                                                        <input id="sale_days" type="text" name="sale_days" class="form-control" >

                                                    </div>




                                                </div>
                                            </div>






                                            <p>

                                                <button type="button" class="btn btn-primary ml-1" id="runreport" style="width: 130px; margin-top: 10px;">Run Report</button>
                                                <button type="button" class="btn btn-info ml-1" id="runpdf" style="width: 130px; margin-top: 10px;">PDF</button>
                                                <input type="hidden" name="file_name" id="file_name" value="<?php echo $file_name ?>" class="btn btn-success">
                                                <input type="hidden" name="rep_id" id="rep_id" value="<?php echo $rep_id ?>" class="btn btn-success">
                                            </p>

                                        </div>
                                    </div>



                                </div>
                            </div>
                        </div>
                    </div>




                    <div id="view"></div>
                </div>








    </section>

</div>
















<?php include('footer.php'); ?>

 <!----------------------------START JAVA SCRIPT---------------------------->
 <script type="text/javascript">
        $(document).ready(function() {

            $('#fromdate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,

            });

            $('#todate').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
            });


            $('#runreport').click(function()
            {

                var rep_id =  $('#rep_id').val();

                var from_date = $('#fromdate').val();
                var to_date = $('#todate').val();
                var comp_id =  $('#comp_id').val();
                var acct_id =  $('#acct_id').val();
                var sp_id =  $('#sp_id').val();
                var reg_id =  $('#reg_id').val();
                var stock_code =  $('#stock_code').val();
                var color_id =  $('#color_id').val();
                var size_id =  $('#size_id').val();
                var recovery_days =  $('#recovery_days').val();
                var sale_days =  $('#sale_days').val();
                var order_by =  $('#order_by').val();

                var datastring = 'rep_id=' + rep_id + '&from_date=' + from_date + '&to_date=' + to_date + '&comp_id=' + comp_id + '&acct_id=' + acct_id + '&sp_id=' + sp_id + '&reg_id=' + reg_id + '&stock_code=' + stock_code  + '&color_id=' + color_id  + '&size_id=' + size_id  + '&sale_days=' + sale_days  + '&recovery_days=' + recovery_days  + '&order_by=' + order_by  +   '&action=search';

                $.ajax({
                    type:"POST",
                    url:"rpt_sl_process.php",
                    data:datastring,
                    beforeSend: function()
                    {
                        $("#view").html('<br clear="all"><br clear="all"><div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> <img src="images/click_loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                    },
                    success: function(result)
                    {
                        //alert(result)



                        $('#view').html(result);

                    }



                });






            });


        });

    </script>

    <script type="text/javascript">
        $(document).ready(function(){
            $('#comp_id').change(function(){

                var comp_id = $('#comp_id').val();
                var datasend='comp_id='+comp_id;

                $('#loaderc').fadeIn(400).html('<img src="dist/img/ajax-loader.gif" align="absmiddle">');

                $.ajax({

                    type:"POST",
                    data:datasend,
                    url:'select_account.php',
                    cache:false,
                    success:function(msg){

                        $('#acct_id').html(msg);

                        $('#loaderc').fadeOut("slow");

                    }

                });

            });

        });

        $('#runpdf').click(function () {
            var file_name = $('#file_name').val();

            var from_date = $('#fromdate').val();
            var to_date = $('#todate').val();
            var comp_id =  $('#comp_id').val();
            var acct_id =  $('#acct_id').val();
            var rep_id =  $('#rep_id').val();
            var sp_id =  $('#sp_id').val();
            var reg_id =  $('#reg_id').val();
            var stock_code =  $('#stock_code').val();
            var color_id =  $('#color_id').val();
            var size_id =  $('#size_id').val();
            var recovery_days =  $('#recovery_days').val();
            var sale_days =  $('#sale_days').val();
            var order_by =  $('#order_by').val();

            var parameters='from_date='+from_date+'+to_date='+to_date+'+comp_id='+comp_id+'+acct_id='+acct_id+'+rep_id='+rep_id+'+sp_id='+sp_id+'+reg_id='+reg_id+'+stock_code='+stock_code+'+color_id='+color_id+'+size_id='+size_id+'+recovery_days='+recovery_days+'+sale_days='+sale_days+'+order_by='+order_by;
            var datastring = 'file_name=' + file_name + '&parameters=' + parameters;

            $.ajax({
                type:"POST",
                url:"call_pdf.php",
                data:datastring,
                beforeSend: function()
                {
                    $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
                },
                success: function(result)
                {
                    //   alert(result)
                    window.open(result, '_blank');
                }
            });
        });

        
    </script>

    <!----------------------------END JAVA SCRIPT---------------------------->



