<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}

error_reporting(0);
$fromdate = ($_GET['from_date']);
$todate = ($_GET['to_date']);
$compid = ($_GET['comp_id']);
$stock_code = ($_GET['stock_code']);

$ledger = ($_GET['ledger']);

$rep_id = clean_data($_GET['rep_id']);
$file_name = 'pdf_' . $_GET["file_name"];

?>

<?php include('header.php'); ?>

<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Reports</h4>
            </li>
            <li class="breadcrumb-item">
                <a href="reports">
                    Stock</a>
            </li>
            <li class="breadcrumb-item active">Stock Qty</li>
        </ul>




        <div class="section-body">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Stock Qty</h4>
                        </div>
                        <div class="card-body">


                            <div class="box ">
                                <div class="col-md-12 col-12">
                                    <div class="box box-slided-up">
                                        <div class="box-header bg-transparent rounded">
                                            <div class="form-row">

                                                <div class="form-group col-md-2">
                                                    <label>Date From</label>
                                                    <input type="text" class="form-control" name="fromdate" id="fromdate" placeholder="Date From" value="<?php echo date('01-m-Y'); ?>">
                                                </div>


                                                <div class="form-group col-md-2">
                                                    <label>Date to</label>
                                                    <input id="todate" type="text" name="todate" class="form-control" value="<?php echo date('d-m-Y'); ?>">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <label>Company</label>
                                                    <select class="form-control acct_id" name="comp_id" id="comp_id">
                                                        <option value="All">All</option>
                                                        <?php
                                                        $emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
                                                        $comp_id = clean_data($_SESSION["comp_id"]);

                                                        try {
                                                            $comp_sql = "SELECT c.comp_id acct_id, c.comp_name acct_name FROM company c 
                                                        LEFT JOIN users_comp uc on c.comp_id = uc.comp_id
                                                        WHERE uc.emp_id = '$emp_id' ORDER BY c.comp_id";
                                                            $q = $dbcon->prepare($comp_sql);
                                                            $q->execute();
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($row = $q->fetch(PDO::FETCH_OBJ)) {
                                                            echo '<option  value="' . $row->acct_id . '">' . $row->acct_name . '</option>';
                                                        }
                                                        ?>

                                                    </select>
                                                </div>


                                                <div class="form-group col-md-3">
                                                    <label>Product</label>
                                                    <select style="width:100%" name="acct_id" id="acct_id" class="acct_id">

                                                        <option value="All">All</option>
                                                        <?php

                                                        try {
                                                            $p_query = "SELECT i.stock_code, concat(i.description,'-',i.stock_code) description FROM v_item i ORDER BY i.stock_code ASC";
                                                            $p_result = $dbcon->prepare($p_query);
                                                            $p_result->execute(array());
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                            if ($stock_code == $rowd->stock_code && $ledger == 'N') {
                                                                echo '<option  value="' . $rowd->stock_code . '"selected>' . $rowd->description . '</option>';
                                                            } else {
                                                                echo '<option  value="' . $rowd->stock_code . '">' . $rowd->description . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </div>


                                                <div class="form-group col-md-3">
                                                    <label>Category</label>
                                                    <select style="width:100%" name="cat_id" id="cat_id" class="acct_id">

                                                        <option value="All">All</option>
                                                        <?php

                                                        try {
                                                            $p_query = "SELECT c.cat_id, c.cat_name FROM prod_cat c ORDER BY c.cat_id ASC";
                                                            $p_result = $dbcon->prepare($p_query);
                                                            $p_result->execute(array());
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                            echo '<option  value="' . $rowd->cat_id . '">' . $rowd->cat_name . '</option>';
                                                        }

                                                        ?>
                                                    </select>
                                                </div>



                                                <div class="form-group col-md-3">
                                                    <label>Brand</label>
                                                    <select style="width:100%" name="type_id" id="type_id" class="acct_id">

                                                        <option value="All">All</option>
                                                        <?php

                                                        try {
                                                            $p_query = "SELECT c.type_id acct_id, concat(c.type_name,'-',c.type_id) acct_name FROM prod_type c ORDER BY 2 ASC";
                                                            $p_result = $dbcon->prepare($p_query);
                                                            $p_result->execute(array());
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                            echo '<option  value="' . $rowd->acct_id . '">' . $rowd->acct_name . '</option>';
                                                        }

                                                        ?>
                                                    </select>
                                                </div>


                                                <div class="form-group col-md-3">
                                                    <label>Location</label>
                                                    <select style="width:100%" name="loc_id" id="loc_id" class="acct_id">

                                                        <option value="All">All</option>
                                                        <?php


                                                        try {
                                                            $p_query =  "SELECT l.loc_id, l.loc_name FROM location l ORDER BY l.loc_id ASC ";

                                                            $p_result = $dbcon->prepare($p_query);
                                                            $p_result->execute(array());
                                                        } catch (PDOException $e) {
                                                            echo "Error : " . $e->getMessage();
                                                        }

                                                        while ($rowd = $p_result->fetch(PDO::FETCH_OBJ)) {

                                                            echo '<option  value="' . $rowd->loc_id . '">' . $rowd->loc_name . '</option>';
                                                        }

                                                        ?>
                                                    </select>
                                                </div>




                                                <div class="form-group col-md-3">
                                                    <label>Status</label>
                                                    <select name="status" id="status" class=" form-control acct_id" style="width: 100%;">
                                                        <option   value="All">All</option>
                                                        <option   value="Transit">Transit</option>
                                                        <option  value="Arrived" selected >Arrived</option>
                                                    </select>
                                                </div>









                                            </div>











                                            <p>

                                                <button type="button" class="btn btn-light ml-1 btn-lg" id="runreport" style="width: 205px; margin-top: 10px;">Run Report</button>
                                                <input type="hidden" name="file_name" id="file_name" value="<?php echo $file_name ?>" class="btn btn-success">
                                                <input type="hidden" name="rep_id" id="rep_id" value="<?php echo $rep_id ?>" class="btn btn-success">
                                            </p>

                                        </div>
                                    </div>



                                </div>
                            </div>
                        </div>
                    </div>




                    <div id="view"></div>
                </div>








    </section>

</div>
















<?php include('footer.php'); ?>

<!----------------------------START JAVA SCRIPT---------------------------->
<script type="text/javascript">


    /**********DATA LOAD ON WINDOW************/
    /* $(window).on('load', function () {

        var from_date = $('#fromdate').val();
        var to_date = $('#todate').val();
        var comp_id = $('#comp_id').val();
        var acct_id = $('#acct_id').val();


        var datastring = 'from_date=' + from_date + '&to_date=' + to_date + '&comp_id=' + comp_id + '&acct_id=' + acct_id + '&action=search';

        $.ajax({
            type: "POST",
            url: "stock_ledger_process.php",
            data: datastring,
            beforeSend: function () {
                $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
            },
            success: function (result) {
                //alert(result)


                $('#view').html(result);

            }


        });
    });

    */
    /**********END DATA LOAD ON WINDOW************/








    $(document).ready(function() {

        $('#fromdate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            orientation: 'bottom'

        });

        $('#todate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            orientation: 'bottom'
        });


        $('#runreport').click(function()
        {

            var from_date = $('#fromdate').val();
            var to_date = $('#todate').val();
            var comp_id =  $('#comp_id').val();
            var acct_id =  $('#acct_id').val();
            var type_id =  $('#type_id').val();
            var loc_id =  $('#loc_id').val();
            var status =  $('#status').val();


            var datastring = 'from_date=' + from_date + '&to_date=' + to_date + '&comp_id=' + comp_id + '&acct_id=' + acct_id +   '&status=' + status + '&loc_id=' + loc_id   +   '&action=search' + '&type_id=' + type_id;

            $.ajax({
                type:"POST",
                url:"rpt_stock_qty_process.php",
                data:datastring,
                beforeSend: function()
                {
                    $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
                },
                success: function(result)
                {
                    //alert(result)
                    $('#view').html(result);

                }
            });
        });


    });


    $('#runpdf').click(function () {
        var file_name = $('#file_name').val();
        var rep_id =  $('#rep_id').val();

        var from_date = $('#fromdate').val();
        var to_date = $('#todate').val();
        var comp_id = $('#comp_id').val();
        var acct_id =  $('#acct_id').val();
        var cat_id =  $('#cat_id').val();
        var loc_id =  $('#loc_id').val();

        var parameters='from_date='+from_date+'+to_date='+to_date+'+comp_id='+comp_id+'+acct_id='+acct_id+'+cat_id='+cat_id+'+loc_id='+loc_id+'+rep_id='+rep_id;
        var datastring = 'file_name=' + file_name + '&parameters=' + parameters;

        $.ajax({
            type:"POST",
            url:"call_pdf.php",
            data:datastring,
            beforeSend: function()
            {
                $("#view").html('<div class="loader-block cell preloader5"> <div class="circle-5 l"></div> <div class="circle-5 m"></div> <div class="circle-5 r"></div> </div>');
            },
            success: function(result)
            {
                //   alert(result)
                window.open(result, '_blank');
            }
        });
    });

</script>

<!----------------------------END JAVA SCRIPT---------------------------->



