<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");

$comp_id = $_SESSION["comp_id"];






if (!empty($_POST['type'])) {
    $type = $_POST['type'];
    $name = $_POST['name_startsWith'];

    try
    {
        $query =  "SELECT
                            i.stock_code,
                            concat(
                                `i`.`description`,
                            IF
                                ( ( ifnull( `i`.`specs`, '' ) = '' ), '', concat( '-', `i`.`specs` ) ) 
                            ) AS `description`,
                        	if(s.staxp is null,i.staxp, s.staxp) staxp,
                            if(p.rate is not null, p.rate, i.s_rate) s_rate,
                            ifnull(v.bal_qty,0) bal_qty
                    FROM 
                        item i
                        CROSS JOIN system s 
                        LEFT JOIN item_party p ON i.stock_code = p.stock_code
                        LEFT JOIN (select * from v_current_qty where comp_id = '$comp_id') v ON i.stock_code = v.stock_code
                    where  UPPER(i.$type) LIKE '%" . strtoupper($name) . "%'";

        $result = $dbcon->prepare($query);
        $result->execute(array());
    }
    catch(PDOException $e)
    {
        echo "Error : ". $e->getMessage();
    }


    $data = array();
    while($row = $result->fetch(PDO::FETCH_OBJ))
    {
        $name = $row->stock_code .

            '|' . $row->description.
            '|' . round($row->bal_qty).
            '|' . round($row->s_rate).
            '|' . round($row->staxp).
            '|' . round($row->rate);


        array_push($data, $name);
    }
    echo json_encode($data);
    exit;
}





?>