<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
    header("location: login");
}

date_default_timezone_set("Asia/Karachi");

/***********************START VARIABLES*********************/
$filter = $_GET['filter'];

$voucher_type = $_GET['voucher_type'];

$emp_id = clean_data($_SESSION["VALID_USER_NAME"]);
$auth_id = find_value("users", 'auth_id', " and emp_id = '$emp_id'");
$date_close = find_value("v_system", 'date_close', '');
$comp_name = clean_data($_SESSION["COMP_NAME"]);

$menu_id = $_GET['menu_id'];
$menu_cmd = find_value("menu", 'menu_cmd', " and menu_id = '$menu_id'");
$menu_detail = find_value("menu", 'menu_detail', " and menu_id = '$menu_id'");
$menu_link = find_value("menu", 'menu_link', " and menu_id = '$menu_id'") . '&menu_id=' . $menu_id;
$table = find_value("menu", 'menu_table', " and menu_id = '$menu_id'");

$title = find_value("(select concat(ifnull(m1.menu_name,''), ' ', m.menu_name) menu_name
                      from menu m left join menu m1 on m1.menu_id=substr(m.menu_id,1,instr('$menu_id','.')-1)
                      where m.menu_id='$menu_id') v", 'menu_name', "");

$inactive = find_value("users_menu", 'inactive', " and auth_id = '$auth_id' AND menu_id = '$menu_id'  AND inactive = 'N'");

$insert_allowed = find_value("users_menu", 'menu_id', " and auth_id = '$auth_id' AND inactive <> 'Y' and insert_allowed='Y' and menu_id = '$menu_id'");
$update_allowed = find_value("users_menu", 'menu_id', " and auth_id = '$auth_id' AND inactive <> 'Y' and update_allowed='Y' and menu_id = '$menu_id'");
$delete_allowed = find_value("users_menu", 'menu_id', " and auth_id = '$auth_id' AND inactive <> 'Y' and delete_allowed='Y' and menu_id = '$menu_id'");
$post_allowed = find_value("users_menu", 'menu_id', " and auth_id = '$auth_id' AND inactive <> 'Y' and post_allowed='Y' and menu_id = '$menu_id'");
$print_allowed = find_value("users_menu", 'menu_id', " and auth_id = '$auth_id' AND inactive <> 'Y' and print_allowed='Y' and menu_id = '$menu_id'");


$s_date_formt =  find_value('v_system', 'date_format', " ");
$currency_sign = find_value('v_system', 'currency_sign', " ");
$amt_decimals = find_value('v_system', 'amt_decimals', " ");





$comp_id = clean_data($_GET["comp_id"]);
if (empty($comp_id))
    $comp_id = clean_data($_SESSION["comp_id"]);

$year_id = $_GET["year_id"];
if (empty($year_id))
    $year_id = clean_data($_SESSION["year_id"]);

if ($_GET['from_date']) {
    $from_date = $_GET['from_date'];
    $p_from_date = strtotime($from_date);
    $p_from_date = date('Y-m-d', $p_from_date);
}

if ($_GET['to_date']) {
    $to_date = $_GET['to_date'];
    $p_to_date = strtotime($to_date);
    $p_to_date = date('Y-m-d', $p_to_date);
}

$login_page = find_value("v_system", 'login_page', '');
if (!isset($from_date)) {
    if ($login_page == 'kt') {
        $monday = strtotime("last monday");
        $monday = date('w', $monday) == date('w') ? $monday + 7 * 86400 : $monday;
        $sunday = strtotime(date("Y-m-d", $monday) . " +6 days");
        $p_from_date = date("Y-m-d", $monday);
        $from_date = date("d-m-Y", $monday);
    } else {
        $from_date = date('01-01-Y');
        $p_from_date = date('Y-01-01');
    }
}

if (!isset($to_date)) {
    if ($login_page == 'kt') {
        $monday = strtotime("last monday");
        $monday = date('w', $monday) == date('w') ? $monday + 7 * 86400 : $monday;
        $sunday = strtotime(date("Y-m-d", $monday) . " +6 days");
        $p_to_date = date("Y-m-d", $sunday);
        $to_date = date("d-m-Y", $sunday);
    } else {
        $to_date = date('d-m-Y');
        $p_to_date = date('Y-m-d');
    }
}
/***************END VARIABLES*****************/


$log = $_GET['log'];

$log_name = '';
$table = 'voucher';
$tabledet = 'voucherdet';
if ($log == 'log_') {
    $table = $log . $table;
    $tabledet = $log . $tabledet;

    $log_name = 'LOG';
}

/********************START PAGE HEADING***************/
if ($voucher_type == 'CP') {
    $h_name = 'Cash Payment Voucher Show Case' . $log_name;
    $page_title = 'Account Payable';
}
if ($voucher_type == 'BP') {
    $h_name = 'Bank Payment Voucher Show Case' . $log_name;
    $page_title = 'Bank Payment';
}
if ($voucher_type == 'CR') {
    $h_name = 'Cash Receipt Voucher Show Case' . $log_name;
    $page_title = 'Accounts Receivable';
}
if ($voucher_type == 'BR') {
    $h_name = 'Bank Receipt Voucher Show Case' . $log_name;
    $page_title = 'Bank Receipt';
}
if ($voucher_type == 'EP') {
    $h_name = 'Bank Receipt Voucher Show Case' . $log_name;
    $page_title = 'Expenses';
}
/********************END PAGE HEADING***************/


/****************START SHOW QUERY****************/
$and = "";
$and .= " AND (substr(m.voucher_id,1,2)) = '$voucher_type'";
if ($comp_id != "All") {
    $and .= " and m.comp_id = '$comp_id'";
} else {
    $and .= " and m.comp_id in(select comp_id from users_comp where emp_id='$emp_id' and inactive<>'Y')";
}
$and .= " AND m.voucher_date  BETWEEN '$p_from_date' AND '$p_to_date'";

$table = $log . 'voucher';
$tabledet = $log . 'voucherdet';

try {
    $voucher_query = "SELECT DISTINCT m.voucher_id, m.voucher_date,  m.posted, m.comp_id, m.year_id, concat(n.acct_name,'-',m.acct_id) acct_name, f_gl_products(m.comp_id, m.year_id, m.voucher_id) items, d.amount
                                                    FROM $table m 
                                                    LEFT JOIN nom n on m.acct_id=n.acct_id  
                                                    LEFT JOIN (select comp_id, year_id, voucher_id, sum(debit) amount from $tabledet group by comp_id, year_id, voucher_id) d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
                                                    WHERE 1=1  $and ORDER BY  m.voucher_date, post_date DESC";
    //echo $voucher_query;

    $voucher_result = $dbcon->prepare($voucher_query);
    $voucher_result->execute(array());
} catch (PDOException $e) {
    echo "Error : " . $e->getMessage();
}
/****************END SHOW QUERY****************/

?>
<?php include('header.php'); ?>


<title><?php echo $page_title; ?> | <?php echo $row->acct_name; ?></title>

<?php include('left.php'); ?>



<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <ul class="breadcrumb breadcrumb-style ">
            <li class="breadcrumb-item">
                <h4 class="page-title m-b-0">Accounts</h4>
            </li>

            <li class="breadcrumb-item active"><?php echo $page_title; ?></li>
        </ul>




        <div class="section-body">


            <?php
            if($inactive != 'N' && $auth_id != '1' )
            {
                ?>
                <script type="text/javascript">
                    var unaothrize =  "Un Athorized To View";
                    alert(unaothrize);
                    window.location = "index";
                </script>

                <?php
            }
            else
            {
            ?>


            <div class="row">






        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">


                        <div id="buttons" class="pull-right"></div>
                        <br clear="all"><br clear="all">


                        <div class="pull-left text-left">

                            <div class="input-group mb-3 ">
                                <div class="input-group-prepend">
                                    <span class="input-group-text btn-light" id="basic-addon3">Search</span>
                                </div>
                                <input type="text" class="form-control form-control-md" id="myInputTextField" placeholder="Search" aria-describedby="basic-addon3">
                            </div>
                        </div>




                        <div class="pull-left text-left customselect">
                            <select name='c_length_change' id='c_length_change' class="form-control customselect form-control-md" style="margin-left: 20px;">
                                <option value='10'>10</option>
                                <option value='25'>25</option>
                                <option value='50'>50</option>
                                <option value='-1'>All</option>
                            </select>
                        </div>



                        <!---------------------START NEW VOUCHER------------------->

                            <?php
                            if (!empty($insert_allowed) or ($auth_id == '1')) {
                                ?>
                                <form method="get" action="<?php echo $menu_cmd; ?>">
                                    <input type="hidden" name="add" value="Y">
                                    <input type="hidden" name="menu_id" value="<?php echo $menu_id; ?>">
                                    <input type="hidden" name="voucher_type" value="<?php echo $voucher_type; ?>">
                                    <button type="submit" class="btn btn-light btn-lg pull-right font-15" style="width: 205px;">
                                        <i class="fa fa-plus"></i> Add Voucher
                                    </button>
                                </form>
                            <?php } ?>

                        <!---------------------END NEW VOUCHER------------------->


                        <div class="table-responsive">
                            <table id="voucher_table" class="table table-bordered table-hover display" style="text-align: center;">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>ID</th>
                                        <th>Account</th>
                                        <th>Amount</th>
                                        <th>Posted</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody style="color: #000000; text-align: center;">


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


</div>

            <?php } ?>




</section>




</div>


<?php include('footer.php'); ?>


<script type="text/javascript">
    $('#fromdate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,

    });

    $('#todate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    });



    //delete voucher
    function delete_voucher(voucherid, comp_id, year_id, table) {
        //var status = confirm("Are you sure want to Full Voucher Delete");

        var datastring = 'voucherid=' + voucherid + '&comp_id=' + comp_id + '&year_id=' + year_id + '&table=' + table + '&action=' + 'delete_voucher';


        bootbox.dialog({
            message: "Are you sure you want to delete this ?",
            title: "<i class='glyphicon glyphicon-trash'></i> Delete",
            buttons: {
                success: {
                    label: "No, don't delete",
                    className: "btn-success btn-md w-150 boot_box_cls_btn",
                    callback: function() {
                        $('.bootbox').modal('hide');
                    }
                },
                danger: {
                    label: "Yes, delete",
                    className: "btn-danger btn-md w-150 boot_box_cls_btn",
                    callback: function() {
                        $.ajax({

                            type: 'POST',
                            url: 'delete_voucher.php',
                            data: datastring,
                            success: function(response) {

                                //alert(response);

                                window.location = "<?php echo $menu_link; ?>"
                            }
                        });


                    }
                }

            },
            onEscape: false,
            backdrop: true,
        });

    }






    $(document).ready(function () {
        $( "#btn_edit_form" ).click(function() {


            bootbox.dialog({
                message: "Are you sure you want to edit this ?",
                title: "<i class='glyphicon glyphicon-trash'></i> Edit",
                buttons: {
                    success: {
                        label: "No, don't edit",
                        className: "btn-success btn-md w-150 boot_box_cls_btn",
                        callback: function() {
                            $('.bootbox').modal('hide');
                        }
                    },
                    danger: {
                        label: "Yes, edit",
                        className: "btn-danger btn-md w-150 boot_box_cls_btn",
                        callback: function() {

                            $( "#edit_form" ).submit();


                        }
                    }

                },
                onEscape: false,
                backdrop: true,
            })




        });
    });








    $( document ).ready(function() {
        $('#voucher_table').DataTable({
            "bProcessing": true,
            "serverSide": true,
            "ajax":{
                url :"server_voucher.php", // json datasource
                type: "post",  // type of method  ,GET/POST/DELETE
                error: function(){
                    $("#voucher_table_processing").css("display","none");
                }
            },

            columns: [

                { data: "voucher_id" },
                { data: "voucher_date" },
                { data: "acct_name" },
                { data: "amount" },



                {
                    data: null,
                    className: "dt-center editor-edit",
                    defaultContent: '<i class="fa fa-pencil"/>',
                    defaultContent: '<i class="fa fa-trash"/>',
                    orderable: false
                },
                {
                    data: null,
                    className: "dt-center editor-delete",
                    defaultContent: '<i class="fa fa-trash"/>',
                    orderable: false
                }
            ]
















        });



















    });




</script>